/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.syntaxserver;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.syntaxserver.CompletionResultRequestor;

public class ModelBasedSearchableEnvironment
extends SearchableEnvironment {
    public ModelBasedSearchableEnvironment(JavaProject javaProject, WorkingCopyOwner owner, boolean excludeTestCode) throws JavaModelException {
        super(javaProject, owner, excludeTestCode);
    }

    public void findTypes(char[] prefix, boolean findMembers, int matchRule, int searchFor, ISearchRequestor storage, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        JavaLanguageServerPlugin.logInfo("Search engine disabled, searching directly.");
        this.findTypes(new String(prefix), storage, ModelBasedSearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
    }

    private static int convertSearchFilterToModelFilter(int searchFilter) {
        switch (searchFilter) {
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 6;
            }
        }
        return 0x100001E;
    }

    public void findTypes(String prefix, ISearchRequestor storage, int type) {
        CompletionResultRequestor requestor = new CompletionResultRequestor(storage, this.unitToSkip, (IJavaProject)this.project, this.nameLookup);
        int index = prefix.lastIndexOf(46);
        if (index == -1) {
            this.nameLookup.seekTypes(prefix, null, true, type, (IJavaElementRequestor)requestor);
        } else {
            String packageName = prefix.substring(0, index);
            JavaElementRequestor elementRequestor = new JavaElementRequestor();
            this.nameLookup.seekPackageFragments(packageName, false, (IJavaElementRequestor)elementRequestor);
            IPackageFragment[] fragments = elementRequestor.getPackageFragments();
            if (fragments != null) {
                String className = prefix.substring(index + 1);
                IPackageFragment[] iPackageFragmentArray = fragments;
                int n = fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment fragment = iPackageFragmentArray[n2];
                    if (fragment != null) {
                        this.nameLookup.seekTypes(className, fragment, true, type, (IJavaElementRequestor)requestor);
                    }
                    ++n2;
                }
            }
        }
    }

    public void setUnitToSkip(ICompilationUnit unitToSkip) {
        this.unitToSkip = unitToSkip;
    }
}

