/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.common;

import com.microsoft.java.test.runner.common.MessageUtils;
import com.microsoft.java.test.runner.common.Pair;
import com.microsoft.java.test.runner.common.TestOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class TestRunnerMessageHelper {
    public static void reporterAttached() {
        TestOutputStream.instance().println(MessageUtils.create("testReporterAttached", (List<Pair>)null));
    }

    public static void rootPresentation() {
        TestOutputStream.instance().println(MessageUtils.createWithName("rootName", "Default Suite"));
    }

    public static void testStarted(String name) {
        TestOutputStream.instance().println(MessageUtils.createWithName("testStarted", name));
    }

    public static void testIgnored(String name) {
        TestOutputStream.instance().println(MessageUtils.createWithName("testIgnored", name));
    }

    public static void testFinished(String name, long duration) {
        TestOutputStream.instance().println(MessageUtils.create("testFinished", new Pair("name", name), new Pair("duration", String.valueOf(duration))));
    }

    public static void testSuiteFinished(String className) {
        TestOutputStream.instance().println(MessageUtils.createWithName("testSuiteFinished", className));
    }

    public static void testSuiteStarted(String className) {
        TestOutputStream.instance().println(MessageUtils.createWithName("testSuiteStarted", className));
    }

    public static void treeNode(String className, String methodName) {
        TestOutputStream.instance().println(MessageUtils.createWithName("suiteTreeNode", methodName));
    }

    public static void suiteTreeNodeStarted(String className) {
        TestOutputStream.instance().println(MessageUtils.createWithName("suiteTreeStarted", className));
    }

    public static void suiteTreeNodeEnded(String className) {
        TestOutputStream.instance().println(MessageUtils.createWithName("suiteTreeEnded", className));
    }

    public static void testFailed(String name, Throwable exception, long duration) {
        ArrayList<Pair> attributes = new ArrayList<Pair>();
        attributes.add(new Pair("name", name));
        if (exception != null) {
            String failMessage = exception.getMessage();
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            exception.printStackTrace(printWriter);
            String stackTrace = writer.getBuffer().toString();
            attributes.add(new Pair("message", failMessage));
            attributes.add(new Pair("trace", stackTrace));
        } else {
            attributes.add(new Pair("message", ""));
        }
        attributes.add(new Pair("duration", String.valueOf(duration)));
        TestOutputStream.instance().println(MessageUtils.create("testFailed", attributes));
    }

    public static void testRunFinished(int all, int fail, int skip) {
        String message = String.format("Total tests run: %d, Failures: %d, Skips: %d", all, fail, skip);
        TestOutputStream.instance().println(MessageUtils.create("testSummary", new Pair("message", message)));
    }
}

