/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.manipulation.CodeTemplateContextType;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.handlers.FormatterHandler;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.CodeGenerationTemplate;
import org.eclipse.jdt.ls.core.internal.preferences.CodeTemplatePreferences;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.text.templates.TemplateStoreCore;

public class PreferenceManager {
    private Preferences preferences = new Preferences();
    private static final String CUSTOM_CODE_TEMPLATES = "org.eclipse.jdt.ls.core.custom_code_templates";
    private ClientPreferences clientPreferences;
    private ListenerList<IPreferencesChangeListener> preferencesChangeListeners = new ListenerList();
    private IEclipsePreferences eclipsePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
    private static Map<String, Template> templates = new LinkedHashMap<String, Template>();

    public PreferenceManager() {
        PreferenceManager.initialize();
    }

    public static void initialize() {
        PreferenceManager.initializeJavaCoreOptions();
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        defEclipsePrefs.put("org.eclipse.jdt.ui.typefilter.enabled", "");
        defEclipsePrefs.put("org.eclipse.jdt.ui.importorder", String.join((CharSequence)";", Preferences.JAVA_IMPORT_ORDER_DEFAULT));
        defEclipsePrefs.put("outlinesortoption", "T,SF,SI,SM,F,I,C,M");
        defEclipsePrefs.put("org.eclipse.jdt.ui.visibility.order", "B,R,D,V");
        defEclipsePrefs.put("org.eclipse.jdt.ui.overrideannotation", Boolean.TRUE.toString());
        IEclipsePreferences fDefaultPreferenceStore = DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId());
        fDefaultPreferenceStore.put("content_assist_favorite_static_members", String.join((CharSequence)";", Preferences.JAVA_COMPLETION_FAVORITE_MEMBERS_DEFAULT));
        defEclipsePrefs.put("org.eclipse.jdt.ui.keywordthis", Boolean.FALSE.toString());
        defEclipsePrefs.put("org.eclipse.jdt.ui.gettersetter.use.is", Boolean.TRUE.toString());
        defEclipsePrefs.put("org.eclipse.jdt.ui.exception.name", "e");
        defEclipsePrefs.put("org.eclipse.jdt.ui.javadoc", Boolean.FALSE.toString());
        defEclipsePrefs.put("recommenders.chain.min_chain_length", "2");
        defEclipsePrefs.put("recommenders.chain.max_chain_length", "3");
        defEclipsePrefs.put("recommenders.chain.max_chains", "20");
        defEclipsePrefs.put("recommenders.chain.timeout", "1");
        defEclipsePrefs.put("recommenders.chain.ignore_types", "");
        ContextTypeRegistry registry = new ContextTypeRegistry();
        CodeTemplateContextType.registerContextTypes((ContextTypeRegistry)registry);
        for (String contextTypeId : List.of("classsnippet_context", "interfacesnippet_context", "recordsnippet_context")) {
            CodeTemplateContextType contextType = new CodeTemplateContextType(contextTypeId);
            contextType.addResolver((TemplateVariableResolver)new CodeTemplateContextType.CodeTemplateVariableResolver("filecomment", JavaManipulationMessages.CodeTemplateContextType_variable_description_filecomment));
            registry.addContextType((TemplateContextType)contextType);
        }
        TemplateContextType tmp = registry.getContextType("typecomment_context");
        tmp.addResolver((TemplateVariableResolver)new CodeTemplatePreferences.Month());
        tmp.addResolver((TemplateVariableResolver)new CodeTemplatePreferences.ShortMonth());
        tmp.addResolver((TemplateVariableResolver)new CodeTemplatePreferences.Day());
        tmp.addResolver((TemplateVariableResolver)new CodeTemplatePreferences.Hour());
        tmp.addResolver((TemplateVariableResolver)new CodeTemplatePreferences.Minute());
        JavaManipulation.setCodeTemplateContextRegistry((ContextTypeRegistry)registry);
        templates.put("org.eclipse.jdt.ui.text.codetemplates.fieldcomment", CodeGenerationTemplate.FIELDCOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.methodcomment", CodeGenerationTemplate.METHODCOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.constructorcomment", CodeGenerationTemplate.CONSTRUCTORCOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.constructorbody", CodeGenerationTemplate.CONSTRUCTORBODY.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.delegatecomment", CodeGenerationTemplate.DELEGATECOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.overridecomment", CodeGenerationTemplate.OVERRIDECOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.typecomment", CodeGenerationTemplate.TYPECOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.gettercomment", CodeGenerationTemplate.GETTERCOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.settercomment", CodeGenerationTemplate.SETTERCOMMENT.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.getterbody", CodeGenerationTemplate.GETTERBODY.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.setterbody", CodeGenerationTemplate.SETTERBOY.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.catchblock", CodeGenerationTemplate.CATCHBODY.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.methodbody", CodeGenerationTemplate.METHODBODY.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.methodbodyalternative", CodeGenerationTemplate.METHODBODYSUPER.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.newtype", CodeGenerationTemplate.NEWTYPE.createTemplate());
        templates.put("org.eclipse.jdt.ui.text.codetemplates.filecomment", CodeGenerationTemplate.FILECOMMENT.createTemplate());
        PreferenceManager.reloadTemplateStore();
    }

    public static void initializeJavaCoreOptions() {
        Hashtable javaCoreOptions = JavaCore.getOptions();
        javaCoreOptions.put("org.eclipse.jdt.core.codeComplete.visibilityCheck", "enabled");
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.release", "enabled");
        javaCoreOptions.putAll(FormatterHandler.getJavaLSDefaultFormatterSettings());
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", "ignore");
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "warning");
        javaCoreOptions.put("org.eclipse.jdt.core.codeComplete.subwordMatch", "disabled");
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        javaCoreOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        javaCoreOptions.put("org.eclipse.jdt.core.compiler.ignoreUnnamedModuleForSplitPackage", "enabled");
        if (!Objects.equals(javaCoreOptions, JavaCore.getOptions())) {
            JavaCore.setOptions((Hashtable)javaCoreOptions);
        }
    }

    private static void reloadTemplateStore() {
        IEclipsePreferences defEclipsePrefs = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        TemplatePersistenceData[] templateData = templates.values().stream().map(t -> new TemplatePersistenceData(t, true, t.getDescription())).collect(Collectors.toList()).toArray(new TemplatePersistenceData[0]);
        TemplateReaderWriter trw = new TemplateReaderWriter();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter wrt = new StringWriter();){
                trw.save(templateData, (Writer)wrt);
                defEclipsePrefs.put(CUSTOM_CODE_TEMPLATES, ((Object)wrt).toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TemplateStoreCore tscore = new TemplateStoreCore(defEclipsePrefs, CUSTOM_CODE_TEMPLATES);
        try {
            tscore.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JavaManipulation.setCodeTemplateStore((TemplateStoreCore)tscore);
    }

    private static boolean updateTemplate(String templateId, String content) {
        Template template = templates.get(templateId);
        if (StringUtils.isEmpty((CharSequence)content) && template == null || template != null && Objects.equals(content, template.getPattern())) {
            return false;
        }
        CodeGenerationTemplate codeTemplate = CodeGenerationTemplate.getValueById(templateId);
        if (codeTemplate == null) {
            return false;
        }
        templates.put(templateId, codeTemplate.createTemplate(content));
        return true;
    }

    public void update(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        Preferences oldPreferences = this.preferences;
        this.preferences = preferences;
        this.preferencesChanged(oldPreferences, preferences);
        boolean templateChanged = false;
        List<String> fileHeader = preferences.getFileHeaderTemplate();
        String content = fileHeader == null ? "" : String.join((CharSequence)"\n", fileHeader);
        templateChanged |= PreferenceManager.updateTemplate("org.eclipse.jdt.ui.text.codetemplates.filecomment", content);
        List<String> typeComment = preferences.getTypeCommentTemplate();
        String string = content = typeComment == null ? "" : String.join((CharSequence)"\n", typeComment);
        if (templateChanged |= PreferenceManager.updateTemplate("org.eclipse.jdt.ui.text.codetemplates.typecomment", content)) {
            PreferenceManager.reloadTemplateStore();
        }
        Hashtable options = JavaCore.getOptions();
        preferences.updateTabSizeInsertSpaces(options);
        if (!Objects.equals(options, JavaCore.getOptions())) {
            JavaCore.setOptions((Hashtable)options);
        }
        List<String> resourceFilters = preferences.getResourceFilters();
        IEclipsePreferences eclipsePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        eclipsePreferences.put("java.project.resourceFilters", String.join((CharSequence)"::", resourceFilters));
    }

    private void preferencesChanged(final Preferences oldPreferences, final Preferences newPreferences) {
        for (final IPreferencesChangeListener listener : this.preferencesChangeListeners) {
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable e) {
                    JavaLanguageServerPlugin.log(new CoreException(StatusFactory.newErrorStatus(e.getMessage(), e)));
                }

                public void run() throws Exception {
                    listener.preferencesChange(oldPreferences, newPreferences);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
        }
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Preferences getPreferences(IResource resource) {
        return this.preferences;
    }

    public ClientPreferences getClientPreferences() {
        return this.clientPreferences;
    }

    public void updateClientPrefences(ClientCapabilities clientCapabilities, Map<String, Object> extendedClientCapabilities) {
        this.clientPreferences = new ClientPreferences(clientCapabilities, extendedClientCapabilities);
    }

    public static Preferences getPrefs(IResource resource) {
        return JavaLanguageServerPlugin.getPreferencesManager().getPreferences(resource);
    }

    public static CodeGenerationSettings getCodeGenerationSettings(IResource resource) {
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.overrideAnnotation = true;
        res.createComments = false;
        res.tabWidth = CodeFormatterUtil.getTabWidth((IJavaProject)project);
        res.indentWidth = CodeFormatterUtil.getIndentWidth((IJavaProject)project);
        return res;
    }

    public static CodeGenerationSettings getCodeGenerationSettings(ICompilationUnit cu) {
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.overrideAnnotation = true;
        res.createComments = false;
        res.tabWidth = CodeFormatterUtil.getTabWidth((ICompilationUnit)cu);
        res.indentWidth = CodeFormatterUtil.getIndentWidth((ICompilationUnit)cu);
        return res;
    }

    public void addPreferencesChangeListener(IPreferencesChangeListener listener) {
        this.preferencesChangeListeners.add((Object)listener);
    }

    public void removePreferencesChangeListener(IPreferencesChangeListener listener) {
        this.preferencesChangeListeners.remove((Object)listener);
    }

    public IEclipsePreferences getEclipsePreferences() {
        return this.eclipsePrefs;
    }

    public boolean isClientSupportsClassFileContent() {
        return this.getClientPreferences() != null && this.getClientPreferences().isClassFileContentSupported();
    }

    public boolean isClientSupportsCompletionDocumentationMarkDown() {
        return this.getClientPreferences() != null && this.getClientPreferences().isSupportsCompletionDocumentationMarkdown();
    }
}

