"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooltipComponent = void 0;
const React = __importStar(require("react"));
const react_tooltip_1 = __importDefault(require("react-tooltip"));
class TooltipComponent extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            element: undefined,
            func: undefined,
            content: undefined
        };
    }
    render() {
        return (React.createElement("div", { role: 'tooltip-component-role', onMouseEnter: () => {
                if (this.timerId) {
                    clearTimeout(this.timerId);
                    this.timerId = undefined;
                }
            }, onMouseLeave: () => {
                react_tooltip_1.default.hide();
                this.setState({ content: undefined });
            } },
            React.createElement(react_tooltip_1.default, { className: "react-tooltip", id: "tooltip-component", effect: "float", type: "info", place: "bottom", html: true, delayShow: 500, delayUpdate: 500, afterShow: () => {
                    if (this.timerId) {
                        clearTimeout(this.timerId);
                        this.timerId = undefined;
                    }
                    if (this.state.content === undefined) {
                        this.fetchContent(this.state.element);
                    }
                }, clickable: true, scrollHide: true, arrowColor: "transparent", overridePosition: ({ left, top }, currentEvent, currentTarget, refNode, place) => {
                    left += place === 'left' ? -10 : place === 'right' ? 10 : 0;
                    top += place === 'top' ? -10 : 0;
                    return { left, top };
                }, getContent: () => this.getContent() })));
    }
    setElement(element, func) {
        if (element !== this.state.element && this.state.element) {
            if (this.state.content) {
                if (this.timerId === undefined) {
                    // allow 500 ms to move mouse over the tooltip
                    this.timerId = setTimeout(() => {
                        if (this.state.element !== element || this.state.element === undefined) {
                            react_tooltip_1.default.hide();
                            this.setState({ content: undefined });
                        }
                    }, 500);
                }
            }
            else {
                // content being fetched, hide the hourglass tooltip
                react_tooltip_1.default.hide();
            }
        }
        this.setState({ element, func });
    }
    getContent() {
        if (this.state.content) {
            return this.state.content;
        }
        if (this.state.element) {
            return TooltipComponent.HOURGLASS_NOT_DONE;
        }
        return undefined;
    }
    async fetchContent(element) {
        if (this.state.element && this.state.func) {
            const tooltipInfo = await this.state.func(element);
            let content = '<table>';
            if (tooltipInfo) {
                Object.entries(tooltipInfo).forEach(([k, v]) => (content += this.tooltipRow(k, v)));
            }
            content += '</table>';
            if (this.state.element === element) {
                this.setState({ content });
            }
        }
    }
    tooltipRow(key, value) {
        return '<tr><td style="text-align:left">' + key + '</td><td style="text-align:left">' + value + '</td></tr>';
    }
}
exports.TooltipComponent = TooltipComponent;
TooltipComponent.HOURGLASS_NOT_DONE = '&#x23f3;';
//# sourceMappingURL=tooltip-component.js.map