"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataTreeOutputComponent = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
const abstract_output_component_1 = require("./abstract-output-component");
const React = __importStar(require("react"));
const react_contexify_1 = require("react-contexify");
const query_helper_1 = require("tsp-typescript-client/lib/models/query/query-helper");
const data_type_1 = require("tsp-typescript-client/lib/models/data-type");
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const entry_tree_1 = require("./utils/filter-tree/entry-tree");
const utils_1 = require("./utils/filter-tree/utils");
const lodash_debounce_1 = __importDefault(require("lodash.debounce"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
require("../../style/react-contextify.css");
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const MENU_ID = 'datatree.context.menuId ';
class DataTreeOutputComponent extends abstract_output_component_1.AbstractOutputComponent {
    constructor(props) {
        super(props);
        this.treeRef = React.createRef();
        this._debouncedFetchSelectionData = (0, lodash_debounce_1.default)(() => this.fetchSelectionData(), 500);
        this.handleItemClick = (args) => {
            const tooltip = args.props.data;
            const min = tooltip[args.event.currentTarget.id];
            if (min !== undefined) {
                let rx = /\[(\d*),.*/g;
                let arr = rx.exec(min);
                let start = undefined;
                if (arr) {
                    start = BigInt(arr[1]) - this.props.unitController.offset;
                }
                rx = /.*,(\d*)\]/g;
                arr = rx.exec(min);
                let end = undefined;
                if (arr) {
                    end = BigInt(arr[1]) - this.props.unitController.offset;
                }
                if (start !== undefined && end !== undefined) {
                    this.props.unitController.selectionRange = {
                        start,
                        end
                    };
                }
            }
        };
        this.onContextMenu = (event, id) => {
            event.preventDefault();
            event.stopPropagation();
            this.doContextMenu(event, id);
        };
        this.state = {
            outputStatus: responses_1.ResponseStatus.RUNNING,
            selectedSeriesId: [],
            xyTree: [],
            collapsedNodes: [],
            orderedNodes: [],
            columns: [{ title: 'Name', sortable: true }]
        };
        this.addPinViewOptions();
        this.addOptions('Export to CSV...', () => this.exportOutput());
    }
    componentDidMount() {
        this.waitAnalysisCompletion();
    }
    async fetchTree() {
        const parameters = query_helper_1.QueryHelper.timeRangeQuery(this.props.range.getStart(), this.props.range.getEnd());
        // TODO: use the data tree endpoint instead of the xy tree endpoint
        const tspClientResponse = await this.tryFetchDataTree(parameters);
        const treeResponse = tspClientResponse.getModel();
        if (tspClientResponse.isOk() && treeResponse) {
            if (treeResponse.model) {
                const headers = treeResponse.model.headers;
                const columns = [];
                if (headers && headers.length > 0) {
                    headers.forEach(header => {
                        columns.push({
                            title: header.name,
                            sortable: true,
                            resizable: true,
                            tooltip: header.tooltip,
                            dataType: header.dataType
                        });
                    });
                }
                else {
                    columns.push({ title: 'Name', sortable: true });
                }
                this.setState({
                    outputStatus: treeResponse.status,
                    xyTree: treeResponse.model.entries,
                    columns
                });
            }
            else {
                this.setState({
                    outputStatus: treeResponse.status
                });
            }
            return treeResponse.status;
        }
        this.setState({
            outputStatus: responses_1.ResponseStatus.FAILED
        });
        return responses_1.ResponseStatus.FAILED;
    }
    resultsAreEmpty() {
        return this.state.xyTree.length === 0;
    }
    renderTree() {
        this.onToggleCollapse = this.onToggleCollapse.bind(this);
        this.onOrderChange = this.onOrderChange.bind(this);
        return this.state.xyTree.length ? (React.createElement("div", { tabIndex: 0, id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', className: "scrollable", style: { height: this.props.style.height } },
            React.createElement(entry_tree_1.EntryTree, { entries: this.state.xyTree, showCheckboxes: false, collapsedNodes: this.state.collapsedNodes, onContextMenu: this.onContextMenu, onToggleCollapse: this.onToggleCollapse, onOrderChange: this.onOrderChange, headers: this.state.columns }))) : undefined;
    }
    renderMainArea() {
        return (React.createElement(React.Fragment, null, this.state.outputStatus === responses_1.ResponseStatus.COMPLETED ? (React.createElement("div", null,
            this.renderContextMenu(),
            React.createElement("div", { ref: this.treeRef, className: "output-component-tree disable-select", style: {
                    height: this.props.style.height,
                    width: this.props.outputWidth - this.getHandleWidth()
                } }, this.renderTree()))) : (React.createElement("div", { tabIndex: 0, id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', className: "analysis-running-main-area" },
            React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faSpinner, spin: true, style: { marginRight: '5px' } }),
            React.createElement("span", null, "Analysis running")))));
    }
    renderContextMenu() {
        const timeRanges = [];
        const cols = this.state.columns;
        cols.forEach(col => {
            if (col.dataType === data_type_1.DataType.TIME_RANGE) {
                timeRanges.push(col.title);
            }
        });
        return (React.createElement(React.Fragment, null,
            ' ',
            React.createElement(react_contexify_1.Menu, { id: MENU_ID + this.props.outputDescriptor.id, theme: this.props.backgroundTheme, animation: 'fade' }, timeRanges && timeRanges.length > 0 ? (timeRanges.map(key => (React.createElement(react_contexify_1.Item, { key: key, id: key, onClick: this.handleItemClick },
                "Select ",
                key)))) : (React.createElement(React.Fragment, null)))));
    }
    setFocus() {
        var _a, _b;
        if (document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) {
            (_a = document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else {
            (_b = document.getElementById(this.props.traceId + this.props.outputDescriptor.id)) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }
    async doContextMenu(event, id) {
        if (this.state.xyTree) {
            const timeProperties = {};
            const entry = this.state.xyTree.find(e => e.id === id);
            if (entry && this.state.columns && this.state.columns.length > 0) {
                const cols = this.state.columns;
                for (let i = 0; i < cols.length; i++) {
                    if (cols[i].dataType === data_type_1.DataType.TIME_RANGE) {
                        timeProperties[cols[i].title] = entry.labels[i];
                    }
                }
            }
            if (Object.keys(timeProperties).length > 0) {
                const { show } = (0, react_contexify_1.useContextMenu)({
                    id: MENU_ID + this.props.outputDescriptor.id
                });
                show(event, {
                    props: {
                        data: timeProperties
                    },
                    position: this.getMenuPosition(event)
                });
            }
        }
    }
    getMenuPosition(event) {
        const refNode = this.treeRef.current;
        if (refNode) {
            return {
                // Compute position relative to treeRef
                x: event.clientX - refNode.getBoundingClientRect().left,
                y: event.clientY - refNode.getBoundingClientRect().top
            };
        }
        return {
            x: 0,
            y: 0
        };
    }
    onToggleCollapse(id, nodes) {
        let newList = [...this.state.collapsedNodes];
        const exist = this.state.collapsedNodes.find(expandId => expandId === id);
        if (exist !== undefined) {
            newList = newList.filter(collapsed => id !== collapsed);
        }
        else {
            newList = newList.concat(id);
        }
        const orderedIds = (0, utils_1.getAllExpandedNodeIds)(nodes, newList);
        this.setState({ collapsedNodes: newList, orderedNodes: orderedIds });
    }
    onOrderChange(ids) {
        this.setState({ orderedNodes: ids });
    }
    async waitAnalysisCompletion() {
        let outputStatus = this.state.outputStatus;
        const timeout = 500;
        while (this.state && outputStatus === responses_1.ResponseStatus.RUNNING) {
            outputStatus = await this.fetchTree();
            await new Promise(resolve => setTimeout(resolve, timeout));
        }
    }
    componentWillUnmount() {
        // fix Warning: Can't perform a React state update on an unmounted component
        this.setState = (_state, _callback) => undefined;
    }
    async fetchSelectionData() {
        if (this.props.selectionRange) {
            let payload;
            if (this.props.selectionRange.getStart() < this.props.selectionRange.getEnd()) {
                payload = query_helper_1.QueryHelper.timeRangeQuery(this.props.selectionRange.getStart(), this.props.selectionRange.getEnd());
            }
            else {
                payload = query_helper_1.QueryHelper.timeRangeQuery(this.props.selectionRange.getEnd(), this.props.selectionRange.getStart());
            }
            payload.parameters.isFiltered = true;
            // TODO: use the data tree endpoint instead of the xy tree endpoint
            const tspClientResponse = await this.tryFetchDataTree(payload);
            const treeResponse = tspClientResponse.getModel();
            if (tspClientResponse.isOk() && treeResponse) {
                if (treeResponse.model) {
                    this.setState({
                        outputStatus: treeResponse.status,
                        xyTree: treeResponse.model.entries
                    });
                }
            }
        }
    }
    async componentDidUpdate(prevProps) {
        if (this.props.selectionRange && this.props.selectionRange !== prevProps.selectionRange) {
            this._debouncedFetchSelectionData();
        }
    }
    async exportOutput() {
        const focusContainer = document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer');
        if (focusContainer) {
            const table = focusContainer.querySelector('div:nth-child(2) > table');
            if (table) {
                const rows = table.querySelectorAll('tr');
                const csvArray = [];
                for (let i = 0; i < rows.length; i++) {
                    const row = [];
                    const cols = rows[i].querySelectorAll('td, th');
                    for (let j = 0; j < cols.length - 1; j++) {
                        let data;
                        const content = cols[j].textContent;
                        if (content) {
                            data = content.replace(/\s*\|/g, '');
                        }
                        else {
                            data = content;
                        }
                        row.push(data);
                    }
                    csvArray.push(row.join(','));
                }
                const tableString = csvArray.join('\n');
                (0, signal_manager_1.signalManager)().fireSaveAsCsv({
                    traceId: this.props.traceId,
                    data: tableString
                });
            }
        }
    }
    async tryFetchDataTree(payload) {
        let tspClientResponse = await this.props.tspClient.fetchDataTree(this.props.traceId, this.props.outputDescriptor.id, payload);
        if (!tspClientResponse.isOk()) {
            // Older trace servers might not support fetchDatatTree endpoint. Fall-back to fetchXYTree
            tspClientResponse = await this.props.tspClient.fetchXYTree(this.props.traceId, this.props.outputDescriptor.id, payload);
        }
        return tspClientResponse;
    }
}
exports.DataTreeOutputComponent = DataTreeOutputComponent;
//# sourceMappingURL=datatree-output-component.js.map