"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractOutputComponent = void 0;
const React = __importStar(require("react"));
const react_fontawesome_1 = require("@fortawesome/react-fontawesome");
const free_solid_svg_icons_1 = require("@fortawesome/free-solid-svg-icons");
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const drop_down_component_1 = require("./drop-down-component");
class AbstractOutputComponent extends React.Component {
    constructor(props) {
        super(props);
        this.DEFAULT_HANDLE_WIDTH = 30;
        this.PIN_VIEW_LABEL = 'Pin View';
        this.UNPIN_VIEW_LABEL = 'Unpin View';
        this.TOGGLE_COLUMN_LABEL = 'Toggle Columns';
        this.dropDownOptions = [];
        this.mainOutputContainer = React.createRef();
        this.closeComponent = this.closeComponent.bind(this);
        this.renderTitleBar = this.renderTitleBar.bind(this);
        this.toggleDropDown = this.toggleDropDown.bind(this);
        this.openDropDown = this.openDropDown.bind(this);
        this.closeDropDown = this.closeDropDown.bind(this);
        this.dropDownMenuRef = React.createRef();
        this.titleRef = React.createRef();
        this.titleBarLabelRef = React.createRef();
    }
    render() {
        return (React.createElement("div", { style: Object.assign(Object.assign({}, this.props.style), { width: this.props.outputWidth }), id: this.getOutputComponentDomId(), tabIndex: -1, className: 'output-container ' + this.props.className, onMouseUp: this.props.onMouseUp, onMouseDown: this.props.onMouseDown, onTouchStart: this.props.onTouchStart, onTouchEnd: this.props.onTouchEnd, "data-tip": "", "data-for": "tooltip-component" },
            React.createElement("div", { id: this.getOutputComponentDomId() + 'handle', className: this.showViewOptionsCondition() ? 'widget-handle-with-options' : 'widget-handle', style: { width: this.getHandleWidth(), height: this.props.style.height } }, this.renderTitleBar()),
            React.createElement("div", { className: "main-output-container", ref: this.mainOutputContainer, style: { width: this.props.outputWidth - this.getHandleWidth(), height: this.props.style.height } }, this.renderMainOutputContainer()),
            this.props.children));
    }
    renderTitleBar() {
        var _a;
        const outputName = this.getOutputComponentName();
        const outputTooltip = this.getTitleBarTooltip();
        // Manually check overflown titles to fix ellipsis not shown on Safari (issue #764).
        const isOverflown = () => {
            const el = this.titleRef.current;
            const labelHeight = this.titleBarLabelRef.current;
            if (!el || !labelHeight) {
                return false;
            }
            return el.getBoundingClientRect().height > labelHeight.getBoundingClientRect().height;
        };
        const titleOverflown = this.titleRef.current && isOverflown() ? 'custom-ellipsis' : 'hidden-ellipsis';
        return (React.createElement(React.Fragment, null,
            React.createElement("button", { className: "remove-component-button", onClick: this.closeComponent },
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faTimes })),
            this.showViewOptionsCondition() && (React.createElement("div", { className: "options-menu-container" },
                React.createElement("button", { title: "Show View Options", className: "options-menu-button", onClick: this.toggleDropDown },
                    React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faBars })),
                React.createElement(drop_down_component_1.DropDownComponent, Object.assign({ dropDownOpen: (_a = this.state.dropDownOpen) !== null && _a !== void 0 ? _a : false, dropDownOptions: this.dropDownOptions, ref: this.dropDownMenuRef }, this.props)))),
            React.createElement("div", { ref: this.titleBarLabelRef, className: "title-bar-label", title: outputTooltip, onClick: () => this.setFocus() },
                React.createElement("span", { ref: this.titleRef }, outputName),
                React.createElement("span", { className: titleOverflown }, "..."),
                React.createElement(react_fontawesome_1.FontAwesomeIcon, { id: this.getOutputComponentDomId() + 'handleSpinner', icon: free_solid_svg_icons_1.faSpinner, spin: true, style: { marginTop: '5px', visibility: 'hidden' } }),
                this.props.pinned === true && (React.createElement(react_fontawesome_1.FontAwesomeIcon, { icon: free_solid_svg_icons_1.faThumbtack, title: "Pinned View", className: "pin-view-icon" })))));
    }
    showViewOptionsCondition() {
        const nonPinViewOptionExists = this.dropDownOptions.some(option => option.label !== this.PIN_VIEW_LABEL && option.label !== this.UNPIN_VIEW_LABEL);
        return nonPinViewOptionExists || this.props.pinned !== false;
    }
    toggleDropDown() {
        if (this.state.dropDownOpen) {
            this.closeDropDown();
        }
        else {
            this.openDropDown();
        }
    }
    closeDropDown() {
        this.setState({
            dropDownOpen: false
        });
    }
    openDropDown() {
        this.setState({
            dropDownOpen: true
        });
    }
    closeComponent() {
        if (this.props.pinned) {
            (0, signal_manager_1.signalManager)().fireUnPinView(this.props.outputDescriptor);
        }
        this.props.onOutputRemove(this.props.outputDescriptor.id);
    }
    getHandleWidth() {
        return this.props.style.handleWidth || this.DEFAULT_HANDLE_WIDTH;
    }
    getMainAreaWidth() {
        return this.props.outputWidth - this.getHandleWidth();
    }
    renderMainOutputContainer() {
        if (this.state.outputStatus === responses_1.ResponseStatus.FAILED) {
            return this.renderAnalysisFailed();
        }
        if (this.state.outputStatus === responses_1.ResponseStatus.COMPLETED && this.resultsAreEmpty()) {
            return this.renderEmptyResults();
        }
        return this.renderMainArea();
    }
    addPinViewOptions(arg) {
        this.addOptions(this.PIN_VIEW_LABEL, () => this.pinView(), arg, () => this.props.pinned === undefined);
        this.addOptions(this.UNPIN_VIEW_LABEL, () => this.unPinView(), arg, () => this.props.pinned === true);
    }
    addOptions(label, onClick, arg, condition, subSection) {
        var _a;
        const newOption = {
            label: label,
            onClick: onClick,
            arg: arg,
            condition: condition,
            subSection: subSection
        };
        if (this.dropDownOptions.includes(newOption)) {
            return;
        }
        this.dropDownOptions = [...((_a = this.dropDownOptions) !== null && _a !== void 0 ? _a : []), newOption];
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types
    pinView(payload) {
        (0, signal_manager_1.signalManager)().firePinView(this.props.outputDescriptor, payload);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types
    unPinView(payload) {
        if (payload) {
            (0, signal_manager_1.signalManager)().fireUnPinView(this.props.outputDescriptor, payload);
        }
        else {
            (0, signal_manager_1.signalManager)().fireUnPinView(this.props.outputDescriptor);
        }
    }
    renderAnalysisFailed() {
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { className: "message-main-area" }, "Trace analysis failed.")));
    }
    renderEmptyResults() {
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { className: "message-main-area" },
                "Trace analysis complete.",
                React.createElement("br", null),
                "No results: Trace missing required events.")));
    }
    getOutputComponentDomId() {
        return this.props.traceId + this.props.outputDescriptor.id;
    }
    getOutputComponentName() {
        return this.props.outputDescriptor.name;
    }
    getTitleBarTooltip() {
        return this.props.outputDescriptor.name;
    }
}
exports.AbstractOutputComponent = AbstractOutputComponent;
//# sourceMappingURL=abstract-output-component.js.map