"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphContainer = void 0;
var PIXI = require("pixi.js-legacy");
var time_graph_state_controller_1 = require("./time-graph-state-controller");
var time_graph_rectangle_1 = require("./components/time-graph-rectangle");
var TimeGraphContainer = /** @class */ (function () {
    function TimeGraphContainer(config, unitController, extCanvas) {
        var _this = this;
        this.config = config;
        this.unitController = unitController;
        this.extCanvas = extCanvas;
        this.calculatePositionOffset = function () {
            // Currently only using horizontal offset, or "x"
            var _a = _this, unitController = _a.unitController, stateController = _a.stateController;
            var viewRange = unitController.viewRange, worldRange = unitController.worldRange;
            var timeOffset = Number(viewRange.start - worldRange.start);
            var x = -1 * (timeOffset * stateController.zoomFactor);
            _this.stateController.positionOffset = {
                x: x,
                y: 0
            };
        };
        var canvas;
        if (!extCanvas) {
            canvas = document.createElement('canvas');
        }
        else {
            canvas = extCanvas;
        }
        var noWebgl2 = !PIXI.utils.isWebGLSupported() || !canvas.getContext('webgl2');
        canvas.style.width = config.width + 'px';
        canvas.style.height = config.height + 'px';
        canvas.width = config.width;
        canvas.height = config.height;
        canvas.id = config.id;
        canvas.className = "time-graph-canvas ".concat(this.config.classNames || '');
        var ratio = window.devicePixelRatio;
        this.application = new PIXI.Application({
            width: canvas.width,
            height: canvas.height,
            view: canvas,
            backgroundColor: config.backgroundColor,
            transparent: config.transparent,
            sharedTicker: true,
            antialias: true,
            resolution: ratio,
            autoDensity: true,
            forceCanvas: noWebgl2
        });
        this.stage = this.application.stage;
        this.renderer = this.application.renderer;
        this._canvas = this.application.view;
        this.stateController = new time_graph_state_controller_1.TimeGraphStateController(canvas, unitController);
        this.unitController.onViewRangeChanged(this.calculatePositionOffset);
        this.stateController.onWorldRender(this.calculatePositionOffset);
        this.layers = [];
        this.background = new time_graph_rectangle_1.TimeGraphRectangle({
            opacity: 1,
            position: {
                x: 0, y: 0
            },
            height: this.canvas.height,
            width: this.canvas.width,
            color: config.backgroundColor,
        });
        this.background.render();
        this.stage.addChild(this.background.displayObject);
    }
    Object.defineProperty(TimeGraphContainer.prototype, "canvas", {
        get: function () {
            return this._canvas;
        },
        enumerable: false,
        configurable: true
    });
    // if canvas size has changed displayWidth need to be updated for zoomfactor
    TimeGraphContainer.prototype.updateCanvas = function (newWidth, newHeight, newColor, lineColor) {
        this.config.width = newWidth;
        this.config.height = newHeight;
        if (newColor) {
            this.config.backgroundColor = newColor;
        }
        var opts = { lineColor: lineColor };
        this.application.renderer.resize(newWidth, newHeight);
        this.stateController.updateDisplayWidth();
        this.stateController.updateDisplayHeight();
        this.background.update({
            position: {
                x: 0, y: 0
            },
            height: newHeight,
            width: newWidth,
            color: newColor
        });
        this.layers.forEach(function (l) { return l.update(opts); });
    };
    TimeGraphContainer.prototype.addLayers = function (layers) {
        var _this = this;
        layers.forEach(function (layer) { return _this.addLayer(layer); });
    };
    TimeGraphContainer.prototype.addLayer = function (layer) {
        this.layers.push(layer);
        layer.initializeLayer(this._canvas, this.stage, this.stateController, this.unitController);
    };
    TimeGraphContainer.prototype.destroy = function () {
        this.layers.forEach(function (l) { return l.destroy(); });
        this.unitController.removeViewRangeChangedHandler(this.calculatePositionOffset);
        this.stateController.removeHandlers();
        this.application.destroy(true);
    };
    return TimeGraphContainer;
}());
exports.TimeGraphContainer = TimeGraphContainer;
//# sourceMappingURL=time-graph-container.js.map