"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackendFileServiceImpl = void 0;
const inversify_1 = require("inversify");
const fs = require("fs");
const path_1 = require("@theia/core/lib/common/path");
const node_1 = require("@theia/core/lib/node");
let BackendFileServiceImpl = class BackendFileServiceImpl {
    async writeToFile(uri, data) {
        fs.writeFile(uri.path.fsPath(), data, err => {
            if (err) {
                throw new Error(err.message);
            }
        });
        return 'success';
    }
    async findTraces(path, cancellationToken) {
        /*
         * On Windows, Theia returns a path that starts with "/" (e.g "/c:/"), causing fsPromise.stat
         * to fail. FileUri.fsPath returns the platform specific path of the orginal Theia path
         * that fixes this issue.
         */
        const cleanedPath = node_1.FileUri.fsPath(path);
        const traces = [];
        const stats = await fs.promises.stat(cleanedPath);
        if (stats.isDirectory()) {
            await this.deepFindTraces(cleanedPath, traces, cancellationToken);
        }
        else if (stats.isFile()) {
            traces.push(cleanedPath);
        }
        if (cancellationToken.isCancellationRequested) {
            return [];
        }
        return traces;
    }
    /**
     * Find traces recursively in the specified folder path, adding the path of
     * found traces to the specified traces array.
     *
     * This implementation only finds CTF traces.
     *
     * @param path current folder path
     * @param traces array of found traces paths
     * @param cancellationToken cancellation token
     * @returns an empty promise
     */
    async deepFindTraces(path, traces, cancellationToken) {
        var e_1, _a;
        const childDirs = [];
        try {
            for (var _b = __asyncValues(await fs.promises.opendir(path)), _c; _c = await _b.next(), !_c.done;) {
                const dirent = _c.value;
                if (cancellationToken.isCancellationRequested) {
                    return;
                }
                if (dirent.isDirectory()) {
                    childDirs.push(dirent);
                }
                else if (dirent.name === 'metadata') {
                    /* This dir is a CTF trace, ignore all child dirs */
                    traces.push(path);
                    return;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) await _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        /* This dir was not a trace, recurse through its child dirs */
        const parent = new path_1.Path(path);
        for (const dirent of childDirs) {
            if (cancellationToken.isCancellationRequested) {
                return;
            }
            const childPath = parent.join(dirent.name);
            await this.deepFindTraces(childPath.toString(), traces, cancellationToken);
        }
    }
};
BackendFileServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], BackendFileServiceImpl);
exports.BackendFileServiceImpl = BackendFileServiceImpl;
//# sourceMappingURL=backend-file-service-impl.js.map