"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceViewerToolbarContribution = void 0;
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const inversify_1 = require("inversify");
const React = __importStar(require("react"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const theia_trace_explorer_opened_traces_widget_1 = require("../trace-explorer/trace-explorer-sub-widgets/theia-trace-explorer-opened-traces-widget");
const charts_cheatsheet_component_1 = require("../trace-explorer/trace-explorer-sub-widgets/charts-cheatsheet-component");
const tsp_client_provider_impl_1 = require("../tsp-client-provider-impl");
const trace_viewer_1 = require("./trace-viewer");
const trace_viewer_toolbar_commands_1 = require("./trace-viewer-toolbar-commands");
const trace_viewer_commands_1 = require("./trace-viewer-commands");
let TraceViewerToolbarContribution = class TraceViewerToolbarContribution {
    constructor() {
        this.onMarkerCategoriesFetchedSignal = () => this.doHandleMarkerCategoriesFetchedSignal();
        this.onMarkerSetsFetchedSignal = () => this.doHandleMarkerSetsFetchedSignal();
        this.onMarkerCategoriesChangedEmitter = new core_1.Emitter();
        this.onMarkerCategoriesChangedEvent = this.onMarkerCategoriesChangedEmitter.event;
        this.onMakerSetsChangedEmitter = new core_1.Emitter();
        this.onMakerSetsChangedEvent = this.onMakerSetsChangedEmitter.event;
    }
    init() {
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.MARKER_CATEGORIES_FETCHED, this.onMarkerCategoriesFetchedSignal);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.MARKERSETS_FETCHED, this.onMarkerSetsFetchedSignal);
    }
    doHandleMarkerCategoriesFetchedSignal() {
        this.onMarkerCategoriesChangedEmitter.fire();
    }
    doHandleMarkerSetsFetchedSignal() {
        this.onMakerSetsChangedEmitter.fire();
    }
    registerCommands(registry) {
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_OVERVIEW_OUTPUT, {
            isVisible: (widget) => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget) {
                    return true;
                }
                return false;
            },
            execute: (widget) => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget && !widget.isTraceOverviewOpened()) {
                    widget.openOverview();
                }
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_IN, {
            isVisible: (widget) => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget) {
                    return widget.isTimeRelatedChartOpened() || widget.isTraceOverviewOpened();
                }
                return false;
            },
            execute: () => {
                (0, signal_manager_1.signalManager)().fireUpdateZoomSignal(true);
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_OUT, {
            isVisible: (w) => {
                if (w instanceof trace_viewer_1.TraceViewerWidget) {
                    const traceWidget = w;
                    return traceWidget.isTimeRelatedChartOpened() || traceWidget.isTraceOverviewOpened();
                }
                return false;
            },
            execute: () => {
                (0, signal_manager_1.signalManager)().fireUpdateZoomSignal(false);
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.UNDO, {
            isVisible: (widget) => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget) {
                    return widget.isTimeRelatedChartOpened() || widget.isTraceOverviewOpened();
                }
                return false;
            },
            execute: () => {
                (0, signal_manager_1.signalManager)().fireUndoSignal();
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.REDO, {
            isVisible: (widget) => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget) {
                    return widget.isTimeRelatedChartOpened() || widget.isTraceOverviewOpened();
                }
                return false;
            },
            execute: () => {
                (0, signal_manager_1.signalManager)().fireRedoSignal();
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.RESET, {
            isVisible: (widget) => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget) {
                    return widget.isTimeRelatedChartOpened() || widget.isTraceOverviewOpened();
                }
                return false;
            },
            execute: () => {
                (0, signal_manager_1.signalManager)().fireResetZoomSignal();
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_TRACE, {
            isVisible: (w) => {
                if (w instanceof theia_trace_explorer_opened_traces_widget_1.TraceExplorerOpenedTracesWidget) {
                    return true;
                }
                return false;
            },
            execute: async () => {
                await registry.executeCommand(trace_viewer_commands_1.OpenTraceCommand.id);
            }
        });
        registry.registerCommand(trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.CHARTS_CHEATSHEET, {
            isVisible: (w) => {
                if (w instanceof trace_viewer_1.TraceViewerWidget) {
                    const traceWidget = w;
                    return (traceWidget.isTimeRelatedChartOpened() ||
                        traceWidget.isTraceOverviewOpened() ||
                        traceWidget.isTableRelatedChartOpened());
                }
                return false;
            },
            execute: async () => {
                await new charts_cheatsheet_component_1.ChartShortcutsDialog({ title: 'Trace Viewer Keyboard and Mouse Shortcuts' }).open();
            }
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.UNDO.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.UNDO.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.UNDO.label,
            priority: 1
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.REDO.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.REDO.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.REDO.label,
            priority: 2
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_IN.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_IN.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_IN.label,
            priority: 3
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_OUT.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_OUT.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.ZOOM_OUT.label,
            priority: 4
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.RESET.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.RESET.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.RESET.label,
            priority: 5
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.FILTER.id,
            isVisible: w => {
                if (w instanceof trace_viewer_1.TraceViewerWidget) {
                    const traceViewerWidget = w;
                    const markerCategories = traceViewerWidget.getMarkerCategories();
                    return markerCategories.size > 0;
                }
                return false;
            },
            // render() here is not a react component and hence need to disable the react display-name rule
            // eslint-disable-next-line react/display-name
            render: (widget) => (React.createElement("div", { className: "item enabled" },
                React.createElement("div", { id: "trace.viewer.toolbar.filter", className: "fa fa-filter", title: "Markers filter", onClick: async (event) => {
                        const toDisposeOnHide = new core_1.DisposableCollection();
                        const menuPath = trace_viewer_toolbar_commands_1.TraceViewerToolbarMenus.MARKER_CATEGORIES_MENU;
                        let index = 1;
                        const traceViewerWidget = widget;
                        const markerCategories = traceViewerWidget.getMarkerCategories();
                        let selectAll = true;
                        markerCategories.forEach((categoryInfo, categoryName) => {
                            const toggleInd = categoryInfo.toggleInd;
                            if (!toggleInd) {
                                selectAll = false;
                            }
                            index += 1;
                            toDisposeOnHide.push(this.menus.registerMenuAction(menuPath, {
                                label: categoryName,
                                commandId: categoryName.toString() + index.toString(),
                                order: index.toString()
                            }));
                            toDisposeOnHide.push(this.commands.registerCommand({
                                id: categoryName.toString() + index.toString(),
                                label: categoryName
                            }, {
                                execute: () => {
                                    traceViewerWidget.updateMarkerCategoryState(categoryName);
                                },
                                isToggled: () => toggleInd
                            }));
                        });
                        toDisposeOnHide.push(this.menus.registerMenuAction(menuPath, {
                            label: 'Select all',
                            commandId: 'Select all' + index.toString(),
                            order: '0'
                        }));
                        toDisposeOnHide.push(this.commands.registerCommand({
                            id: 'Select all' + index.toString(),
                            label: 'Select all'
                        }, {
                            execute: () => {
                                traceViewerWidget.updateAllMarkerCategoryState(!selectAll);
                                return;
                            },
                            isToggled: () => selectAll
                        }));
                        return this.contextMenuRenderer.render({
                            menuPath,
                            args: [],
                            anchor: { x: event.clientX, y: event.clientY },
                            onHide: () => setTimeout(() => toDisposeOnHide.dispose())
                        });
                    } }))),
            priority: 6,
            group: 'navigation',
            onDidChange: this.onMarkerCategoriesChangedEvent
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.MARKER_SETS.id,
            isVisible: widget => {
                if (widget instanceof trace_viewer_1.TraceViewerWidget) {
                    return widget.getMarkerSets().size > 0;
                }
                return false;
            },
            // render() here is not a react component and hence need to disable the react display-name rule
            // eslint-disable-next-line react/display-name
            render: (widget) => (React.createElement("div", { className: "item enabled" },
                React.createElement("div", { id: "trace.viewer.toolbar.markersets", className: "fa fa-bars", title: "Marker Sets", onClick: async (event) => {
                        const toDisposeOnHide = new core_1.DisposableCollection();
                        const menuPath = trace_viewer_toolbar_commands_1.TraceViewerToolbarMenus.MARKER_SETS_MENU;
                        let index = 0;
                        const traceViewerWidget = widget;
                        const markerSetsMap = traceViewerWidget.getMarkerSets();
                        const sortedMarkerSets = Array.from(markerSetsMap.keys()).sort((a, b) => a.id < b.id ? -1 : 1);
                        sortedMarkerSets.forEach(markerSet => {
                            index += 1;
                            toDisposeOnHide.push(this.menus.registerMenuAction(menuPath, {
                                label: markerSet.name,
                                commandId: markerSet.name.toString() + index.toString(),
                                order: String.fromCharCode(index)
                            }));
                            toDisposeOnHide.push(this.commands.registerCommand({
                                id: markerSet.name.toString() + index.toString(),
                                label: markerSet.name
                            }, {
                                execute: () => {
                                    traceViewerWidget.updateMarkerSetState(markerSet);
                                },
                                isToggled: () => !!markerSetsMap.get(markerSet)
                            }));
                        });
                        return this.contextMenuRenderer.render({
                            menuPath,
                            args: [],
                            anchor: { x: event.clientX, y: event.clientY },
                            onHide: () => setTimeout(() => toDisposeOnHide.dispose())
                        });
                    } }))),
            priority: 7,
            group: 'navigation',
            onDidChange: this.onMakerSetsChangedEvent
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_TRACE.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_TRACE.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_TRACE.label,
            priority: 8
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_OVERVIEW_OUTPUT.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_OVERVIEW_OUTPUT.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.OPEN_OVERVIEW_OUTPUT.label,
            priority: 9
        });
        registry.registerItem({
            id: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.CHARTS_CHEATSHEET.id,
            command: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.CHARTS_CHEATSHEET.id,
            tooltip: trace_viewer_toolbar_commands_1.TraceViewerToolbarCommands.CHARTS_CHEATSHEET.label,
            priority: 10
        });
    }
};
__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], TraceViewerToolbarContribution.prototype, "shell", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], TraceViewerToolbarContribution.prototype, "contextMenuRenderer", void 0);
__decorate([
    (0, inversify_1.inject)(tsp_client_provider_impl_1.TspClientProvider),
    __metadata("design:type", tsp_client_provider_impl_1.TspClientProvider)
], TraceViewerToolbarContribution.prototype, "tspClientProvider", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.MenuModelRegistry),
    __metadata("design:type", core_1.MenuModelRegistry)
], TraceViewerToolbarContribution.prototype, "menus", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    __metadata("design:type", core_1.CommandRegistry)
], TraceViewerToolbarContribution.prototype, "commands", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TraceViewerToolbarContribution.prototype, "init", null);
TraceViewerToolbarContribution = __decorate([
    (0, inversify_1.injectable)()
], TraceViewerToolbarContribution);
exports.TraceViewerToolbarContribution = TraceViewerToolbarContribution;
//# sourceMappingURL=trace-viewer-toolbar-contribution.js.map