"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.UndoRedoSource = exports.UndoRedoGroup = exports.ResourceEditStackSnapshot = exports.IUndoRedoService = void 0;
const instantiation_1 = require("../../instantiation/common/instantiation");
exports.IUndoRedoService = (0, instantiation_1.createDecorator)('undoRedoService');
class ResourceEditStackSnapshot {
    constructor(resource, elements) {
        this.resource = resource;
        this.elements = elements;
    }
}
exports.ResourceEditStackSnapshot = ResourceEditStackSnapshot;
class UndoRedoGroup {
    constructor() {
        this.id = UndoRedoGroup._ID++;
        this.order = 1;
    }
    nextOrder() {
        if (this.id === 0) {
            return 0;
        }
        return this.order++;
    }
}
exports.UndoRedoGroup = UndoRedoGroup;
UndoRedoGroup._ID = 0;
UndoRedoGroup.None = new UndoRedoGroup();
class UndoRedoSource {
    constructor() {
        this.id = UndoRedoSource._ID++;
        this.order = 1;
    }
    nextOrder() {
        if (this.id === 0) {
            return 0;
        }
        return this.order++;
    }
}
exports.UndoRedoSource = UndoRedoSource;
UndoRedoSource._ID = 0;
UndoRedoSource.None = new UndoRedoSource();
//# sourceMappingURL=undoRedo.js.map