"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphArrowComponent = void 0;
var PIXI = require("pixi.js-legacy");
var time_graph_component_1 = require("./time-graph-component");
var TimeGraphArrowComponent = /** @class */ (function (_super) {
    __extends(TimeGraphArrowComponent, _super);
    function TimeGraphArrowComponent(id, model, _options) {
        var _this = _super.call(this, id, undefined, model) || this;
        _this._options = _options;
        _this.head = new PIXI.Graphics();
        _this._displayObject.addChild(_this.head);
        return _this;
    }
    TimeGraphArrowComponent.prototype.render = function () {
        var _a = this._options, start = _a.start, end = _a.end;
        this._displayObject.lineStyle(1, 0x000000);
        this._displayObject.moveTo(start.x, start.y);
        this._displayObject.lineTo(end.x, end.y);
        // const edge = Math.sqrt((8*8)+(2*2));
        // const cos_a = Math.cos(Math.atan2(end.y - start.y, end.x - start.x) + Math.atan2(2, 8));
        // const cos_b = Math.cos(Math.atan2(end.y - start.y, end.x - start.x) - Math.atan2(2, 8));
        // const xa = edge * cos_a;
        // const ya = Math.sqrt((edge*edge) - (xa*xa));
        // const xb = edge * cos_b;
        // const yb = Math.sqrt((edge*edge) - (xb*xb));
        // this._displayObject.beginFill(0x000000);
        // this._displayObject.drawPolygon([
        //     end.x, end.y,
        //     end.x - xa, end.y - ya,
        //     end.x - xb, end.y + yb,
        //     end.x, end.y
        // ]);
        // this._displayObject.endFill();
        this.head.clear();
        this.head.beginFill(0x000000);
        this.head.drawPolygon([
            end.x, end.y,
            end.x - 7, end.y - 3,
            end.x - 7, end.y + 3,
            end.x, end.y
        ]);
        this.head.endFill();
        this.head.position.x = end.x;
        this.head.position.y = end.y;
        this.head.pivot = new PIXI.Point(end.x, end.y);
        this.head.rotation = Math.atan2(end.y - start.y, end.x - start.x);
    };
    return TimeGraphArrowComponent;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphArrowComponent = TimeGraphArrowComponent;
//# sourceMappingURL=time-graph-arrow.js.map