"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceServerServiceImpl = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
/* eslint-disable @typescript-eslint/no-non-null-assertion */
/* eslint-disable no-null/no-null */
const child_process_1 = require("child_process");
const fs = require("fs");
const inversify_1 = require("inversify");
const trace_server_config_1 = require("../../common/trace-server-config");
const treeKill = require("tree-kill");
const SUCCESS = 'success';
let TraceServerServiceImpl = class TraceServerServiceImpl {
    async startTraceServer({ path, args } = {}) {
        if (!args) {
            args = '';
        }
        else if (this.isServerRunning(this.server)) {
            if (this.cliArgs === args) {
                return SUCCESS;
            }
            else {
                throw new Error('the Trace Server is already running on a different port');
            }
        }
        path = (path === null || path === void 0 ? void 0 : path.trim()) || await this.findTraceServerPath();
        if (!path) {
            throw new Error('no Trace Server path found');
        }
        else if (!await this.validateTraceServerPath(path)) {
            throw new Error(`could not find the Trace Server file at the specified path: ${path}`);
        }
        const argsArray = args === null || args === void 0 ? void 0 : args.split(' ');
        const server = (0, child_process_1.spawn)(path, argsArray);
        if (server.pid === undefined) {
            // When pid is undefined it usually means we're about to get an error.
            return new Promise((_, reject) => server.once('error', reject));
        }
        this.server = server;
        this.cliArgs = args;
        let timeout;
        try {
            await new Promise((resolve, reject) => {
                // If the server doesn't error or exit within 2 seconds, we consider that a success.
                // That doesn't mean that the server has really started. On the frontend, the `TraceServerConnectionStatusService`
                // will ping the port until it receives a response, which is the official measure of success.
                timeout = setTimeout(resolve, 2000);
                server.once('exit', (code, _signal) => reject((0, trace_server_config_1.PortBusy)(code)));
                server.once('error', reject);
            });
        }
        catch (error) {
            this.server = undefined;
            this.cliArgs = undefined;
            throw error;
        }
        finally {
            server.removeAllListeners();
            clearTimeout(timeout);
        }
        server.once('exit', () => {
            this.server = undefined;
            this.cliArgs = undefined;
        });
        return SUCCESS;
    }
    async stopTraceServer() {
        const { server } = this;
        if (!this.isServerRunning(server)) {
            return SUCCESS;
        }
        await new Promise((resolve, reject) => {
            let exitTimeout;
            // Use `server.on('exit', ...)` as source of truth to detect if the server was successfully killed or not.
            server.once('exit', () => {
                clearTimeout(exitTimeout);
                resolve();
            });
            treeKill(server.pid, error => {
                if (error) {
                    reject(error);
                }
                else {
                    // Give `server.on('exit', ...)` 1s to fire before rejecting with an error.
                    exitTimeout = setTimeout(() => reject(new Error('the Trace Server did not exit')), 1000);
                }
            });
        });
        return SUCCESS;
    }
    async findTraceServerPath() {
        var _a;
        const traceServerPath = (_a = process.env.TRACE_SERVER_PATH) === null || _a === void 0 ? void 0 : _a.trim();
        if (traceServerPath) {
            return traceServerPath;
        }
    }
    async validateTraceServerPath(traceServerPath) {
        const stat = await fs.promises.stat(traceServerPath);
        return stat.isFile() && (stat.mode & fs.constants.R_OK) !== 0;
    }
    isServerRunning(server) {
        // When the process stops, one of `exitCode` or `signalCode` is set.
        return server !== undefined && server.exitCode === null && server.signalCode === null;
    }
};
TraceServerServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], TraceServerServiceImpl);
exports.TraceServerServiceImpl = TraceServerServiceImpl;
//# sourceMappingURL=trace-server-service.js.map