"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.initialize = void 0;
const simpleWorker_1 = require("../base/common/worker/simpleWorker");
const editorSimpleWorker_1 = require("./common/services/editorSimpleWorker");
let initialized = false;
function initialize(foreignModule) {
    if (initialized) {
        return;
    }
    initialized = true;
    const simpleWorker = new simpleWorker_1.SimpleWorkerServer((msg) => {
        self.postMessage(msg);
    }, (host) => new editorSimpleWorker_1.EditorSimpleWorker(host, foreignModule));
    self.onmessage = (e) => {
        simpleWorker.onmessage(e.data);
    };
}
exports.initialize = initialize;
self.onmessage = (e) => {
    // Ignore first message in this case and initialize if not yet initialized
    if (!initialized) {
        initialize(null);
    }
};
//# sourceMappingURL=editor.worker.js.map