"use strict";
// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics, Ericsson, ARM, EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronSecondaryWindowService = void 0;
const electronRemote = require("../../../electron-shared/@electron/remote");
const inversify_1 = require("inversify");
const default_secondary_window_service_1 = require("../../browser/window/default-secondary-window-service");
let ElectronSecondaryWindowService = class ElectronSecondaryWindowService extends default_secondary_window_service_1.DefaultSecondaryWindowService {
    constructor() {
        super(...arguments);
        this.electronWindows = new Map();
    }
    doCreateSecondaryWindow(onClose) {
        const id = this.nextWindowId();
        electronRemote.getCurrentWindow().webContents.once('did-create-window', newElectronWindow => {
            newElectronWindow.setMenuBarVisibility(false);
            this.electronWindows.set(id, newElectronWindow);
            newElectronWindow.on('closed', () => {
                this.electronWindows.delete(id);
                const browserWin = this.secondaryWindows.find(w => w.name === id);
                if (browserWin) {
                    this.handleWindowClosed(browserWin, onClose);
                }
                else {
                    console.warn(`Could not execute proper close handling for secondary window '${id}' because its frontend window could not be found.`);
                }
                ;
            });
        });
        const win = window.open(default_secondary_window_service_1.DefaultSecondaryWindowService.SECONDARY_WINDOW_URL, id);
        return win !== null && win !== void 0 ? win : undefined;
    }
    focus(win) {
        // window.name is the target name given to the window.open call as the second parameter.
        const electronWindow = this.electronWindows.get(win.name);
        if (electronWindow) {
            if (electronWindow.isMinimized()) {
                electronWindow.restore();
            }
            electronWindow.focus();
        }
        else {
            console.warn(`There is no known secondary window '${win.name}'. Thus, the window could not be focussed.`);
        }
    }
};
ElectronSecondaryWindowService = __decorate([
    (0, inversify_1.injectable)()
], ElectronSecondaryWindowService);
exports.ElectronSecondaryWindowService = ElectronSecondaryWindowService;
//# sourceMappingURL=electron-secondary-window-service.js.map