"use strict";
// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositeMenuNodeWrapper = exports.CompositeMenuNode = void 0;
const menu_types_1 = require("./menu-types");
/**
 * Node representing a (sub)menu in the menu tree structure.
 */
class CompositeMenuNode {
    constructor(id, label, options, parent) {
        this.id = id;
        this.label = label;
        this.parent = parent;
        this._children = [];
        this.updateOptions(options);
    }
    get when() { return this._when; }
    get icon() { return this.iconClass; }
    get children() { return this._children; }
    get role() { var _a; return (_a = this._role) !== null && _a !== void 0 ? _a : (this.label ? 0 /* Submenu */ : 1 /* Group */); }
    addNode(node) {
        this._children.push(node);
        this._children.sort(menu_types_1.CompoundMenuNode.sortChildren);
        return {
            dispose: () => {
                const idx = this._children.indexOf(node);
                if (idx >= 0) {
                    this._children.splice(idx, 1);
                }
            }
        };
    }
    removeNode(id) {
        const idx = this._children.findIndex(n => n.id === id);
        if (idx >= 0) {
            this._children.splice(idx, 1);
        }
    }
    updateOptions(options) {
        var _a, _b, _c, _d, _e, _f;
        if (options) {
            (_a = this.iconClass) !== null && _a !== void 0 ? _a : (this.iconClass = (_b = options.icon) !== null && _b !== void 0 ? _b : options.iconClass);
            (_c = this.label) !== null && _c !== void 0 ? _c : (this.label = options.label);
            (_d = this.order) !== null && _d !== void 0 ? _d : (this.order = options.order);
            (_e = this._role) !== null && _e !== void 0 ? _e : (this._role = options.role);
            (_f = this._when) !== null && _f !== void 0 ? _f : (this._when = options.when);
        }
    }
    get sortString() {
        return this.order || this.id;
    }
    get isSubmenu() {
        return Boolean(this.label);
    }
}
exports.CompositeMenuNode = CompositeMenuNode;
/** @deprecated @since 1.28 use CompoundMenuNode.isNavigationGroup instead */
CompositeMenuNode.isNavigationGroup = menu_types_1.CompoundMenuNode.isNavigationGroup;
class CompositeMenuNodeWrapper {
    constructor(wrapped, parent, options) {
        this.wrapped = wrapped;
        this.parent = parent;
        this.options = options;
    }
    get id() { return this.wrapped.id; }
    get label() { return this.wrapped.label; }
    get sortString() { var _a; return ((_a = this.options) === null || _a === void 0 ? void 0 : _a.order) || this.wrapped.sortString; }
    get isSubmenu() { return Boolean(this.label); }
    get role() { var _a, _b; return (_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.role) !== null && _b !== void 0 ? _b : this.wrapped.role; }
    get icon() { return this.iconClass; }
    get iconClass() { var _a, _b; return (_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.iconClass) !== null && _b !== void 0 ? _b : this.wrapped.icon; }
    get order() { return this.sortString; }
    get when() { var _a, _b; return (_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.when) !== null && _b !== void 0 ? _b : this.wrapped.when; }
    get children() { return this.wrapped.children; }
    addNode(node) { return this.wrapped.addNode(node); }
    removeNode(id) { return this.wrapped.removeNode(id); }
    updateOptions(options) { return this.wrapped.updateOptions(options); }
}
exports.CompositeMenuNodeWrapper = CompositeMenuNodeWrapper;
//# sourceMappingURL=composite-menu-node.js.map