"use strict";
/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleGeneratorServiceImpl = void 0;
const uri_1 = require("@theia/core/lib/common/uri");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const inversify_1 = require("@theia/core/shared/inversify");
const fs = require("fs-extra");
const protocol_1 = require("../common/protocol");
const EXAMPLE_DIRECTORY = 'resources';
let ExampleGeneratorServiceImpl = class ExampleGeneratorServiceImpl {
    async generateExample(exampleId, targetFolderUri) {
        const examplesUri = new uri_1.default(module.path).resolve(`../../${EXAMPLE_DIRECTORY}`).normalizePath();
        const examplesPath = file_uri_1.FileUri.fsPath(examplesUri);
        if (!examplesPath || !fs.existsSync(examplesPath)) {
            throw new Error('Could not find examples folder');
        }
        const exampleUri = examplesUri.resolve(exampleId);
        const examplePath = file_uri_1.FileUri.fsPath(exampleUri);
        if (!examplePath || !fs.existsSync(examplePath)) {
            throw new Error(`Could not find files in ${examplePath}`);
        }
        const targetUri = new uri_1.default(targetFolderUri);
        const targetPath = file_uri_1.FileUri.fsPath(targetUri);
        fs.copySync(examplePath, targetPath, { recursive: true, errorOnExist: true });
        const fileToBeOpened = this.getFileToBeOpened(exampleId);
        if (fileToBeOpened) {
            return file_uri_1.FileUri.fsPath(targetUri.resolve(fileToBeOpened));
        }
        return undefined;
    }
    getFileToBeOpened(exampleId) {
        if (exampleId === protocol_1.Examples.CMAKE_EXAMPLE) {
            return 'CMAKE_EXAMPLE_README.md';
        }
        if (exampleId === protocol_1.Examples.CLANGD_CONTEXTS) {
            return 'CLANGD_CONTEXTS_README.md';
        }
        if (exampleId === protocol_1.Examples.EXAMPLE_TRACES) {
            return 'EXAMPLE_TRACES_README.md';
        }
        return undefined;
    }
};
ExampleGeneratorServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], ExampleGeneratorServiceImpl);
exports.ExampleGeneratorServiceImpl = ExampleGeneratorServiceImpl;
//# sourceMappingURL=example-generator-service.js.map