/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;

public class WindowChangeMonitor
implements IWindowListener {
    public static final String WINDOW_CLOSED = "closed";
    public static final String WINDOW_OPENED = "opened";
    public static final String WINDOW_ACTIVATED = "activated";
    public static final String WINDOW_DEACTIVATED = "deactivated";

    public void windowOpened(IWorkbenchWindow window) {
        InteractionEvent interactionEvent = InteractionEvent.makeCommand((String)this.getWindowOrigin(window), (String)WINDOW_OPENED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    public void windowClosed(IWorkbenchWindow window) {
        InteractionEvent interactionEvent = InteractionEvent.makeCommand((String)this.getWindowOrigin(window), (String)WINDOW_CLOSED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowActivated(IWorkbenchWindow window) {
        InteractionEvent interactionEvent = InteractionEvent.makeCommand((String)this.getWindowOrigin(window), (String)WINDOW_ACTIVATED);
        MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
    }

    protected String getWindowOrigin(IWorkbenchWindow window) {
        return window.getClass().getCanonicalName();
    }
}

