/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards;

import java.util.function.Function;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.CustomParserUtils;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomParserOutputWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.CustomXmlParserInputWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.parsers.wizards.TraceParams;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CustomXmlParserWizard
extends Wizard
implements INewWizard {
    CustomXmlParserInputWizardPage inputPage;
    CustomParserOutputWizardPage outputPage;
    private ISelection selection;
    CustomXmlTraceDefinition fDefinition;
    String initialCategoryName;
    String initialDefinitionName;

    public CustomXmlParserWizard() {
        this(null);
    }

    public CustomXmlParserWizard(CustomXmlTraceDefinition definition) {
        this.fDefinition = definition;
        if (definition != null) {
            this.initialCategoryName = definition.categoryName;
            this.initialDefinitionName = definition.definitionName;
        }
        this.setWindowTitle(Messages.CustomXmlParserInputWizardPage_windowTitle);
    }

    public boolean performFinish() {
        CustomTraceDefinition def = this.outputPage.getDefinition();
        if (this.fDefinition != null) {
            if (!this.initialCategoryName.equals(def.categoryName) || !this.initialDefinitionName.equals(def.definitionName)) {
                CustomXmlTraceDefinition.delete((String)this.initialCategoryName, (String)this.initialDefinitionName);
            }
            CustomParserUtils.cleanup(CustomXmlTrace.buildTraceTypeId((String)this.initialCategoryName, (String)this.initialDefinitionName));
        }
        def.save();
        CustomParserUtils.cleanup(CustomTxtTrace.buildTraceTypeId((String)def.categoryName, (String)def.definitionName));
        return true;
    }

    public void addPages() {
        String traceType = "CustomXmlTrace";
        Function<TraceParams, ITmfTrace> builder = tp -> {
            CustomTraceDefinition definition = tp.getDefinition();
            if (definition instanceof CustomXmlTraceDefinition) {
                try {
                    CustomXmlTrace trace = new CustomXmlTrace(null, (CustomXmlTraceDefinition)definition, tp.getFile().getAbsolutePath(), tp.getCacheSize()){

                        protected ITmfTraceIndexer createIndexer(int interval) {
                            return new TmfCheckpointIndexer((ITmfTrace)this, interval);
                        }
                    };
                    trace.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, false);
                    return trace;
                }
                catch (TmfTraceException e) {
                    Activator.getDefault().logError("Error creating" + traceType + ". File:" + tp.getFile().getAbsolutePath() + String.valueOf((Object)e));
                }
            }
            return null;
        };
        this.inputPage = new CustomXmlParserInputWizardPage(this.selection, this.fDefinition);
        this.addPage((IWizardPage)this.inputPage);
        this.outputPage = new CustomParserOutputWizardPage(this.inputPage, (CustomTraceDefinition)this.fDefinition, traceType, builder);
        this.addPage((IWizardPage)this.outputPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
    }
}

