/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import org.eclipse.cdt.internal.ui.navigator.CNavigatorRenameResourceAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.ide.ResourceSelectionUtil;

public class CNavigatorRefactorActionGroup
extends ActionGroup {
    private RenameResourceAction renameAction;
    private MoveResourceAction moveAction;
    private IShellProvider shellProvider;
    private Tree tree;

    public CNavigatorRefactorActionGroup(IShellProvider aShell, Tree aTree) {
        this.shellProvider = aShell;
        this.tree = aTree;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean anyResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType((IStructuredSelection)selection, (int)7);
        if (anyResourceSelected) {
            this.moveAction.selectionChanged(selection);
            menu.appendToGroup("group.reorganize", (IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.insertAfter(this.moveAction.getId(), (IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    protected void makeActions() {
        this.moveAction = new MoveResourceAction(this.shellProvider);
        this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
        this.renameAction = new CNavigatorRenameResourceAction(this.shellProvider, this.tree);
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

