/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.opentype.ElementSelectionDialog;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeInHierarchyAction
implements IWorkbenchWindowActionDelegate {
    private static final int[] VISIBLE_TYPES = new int[]{65, 67, 80, 63, 69};
    private IWorkbenchWindow fWorkbenchWindow;

    public void run(IAction action) {
        ElementSelectionDialog dialog = new ElementSelectionDialog(this.getShell());
        this.configureDialog(dialog);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        ICElement[] elements = null;
        ITypeReference location = info.getResolvedReference();
        if (location != null) {
            elements = location.getCElements();
        }
        if (elements == null || elements.length == 0) {
            String title = Messages.OpenTypeInHierarchyAction_errorTitle;
            String message = NLS.bind((String)Messages.OpenTypeInHierarchyAction_errorNoDefinition, (Object)info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            TypeHierarchyUI.open(elements[0], this.fWorkbenchWindow);
        }
    }

    private void configureDialog(ElementSelectionDialog dialog) {
        String txt;
        ISelection sel;
        IWorkbenchPart part;
        IWorkbenchPage page;
        dialog.setDialogSettings(this.getClass().getName());
        dialog.setVisibleTypes(VISIBLE_TYPES);
        dialog.setTitle(Messages.OpenTypeInHierarchyAction_title);
        dialog.setUpperListLabel(Messages.OpenTypeInHierarchyAction_upperListLabel);
        dialog.setMessage(Messages.OpenTypeInHierarchyAction_message);
        if (this.fWorkbenchWindow != null && (page = this.fWorkbenchWindow.getActivePage()) != null && (part = page.getActivePart()) instanceof ITextEditor && (sel = ((ITextEditor)part).getSelectionProvider().getSelection()) instanceof ITextSelection && (txt = ((ITextSelection)sel).getText()).length() > 0 && txt.length() < 80) {
            dialog.setFilter(txt, true);
        }
    }

    private Shell getShell() {
        return this.fWorkbenchWindow.getShell();
    }

    public void dispose() {
        this.fWorkbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

