/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdClusterDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDerivedFromPath;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdRegisterDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.tree.AbstractTreePreOrderIterator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class SvdPeripheralDMNode
extends SvdDMNode {
    private String fHexAddress = null;
    private BigInteger fBigAbsoluteAddress = null;
    private String fGroupName = null;
    private String fVersion = null;
    private Boolean fIsSystem = null;
    private static final BigInteger fSystemLimit = new BigInteger("E0000000", 16);

    public SvdPeripheralDMNode(Leaf node) {
        super(node);
    }

    @Override
    public void dispose() {
        this.fBigAbsoluteAddress = null;
        this.fHexAddress = null;
        this.fIsSystem = null;
        this.fGroupName = null;
        this.fVersion = null;
        super.dispose();
    }

    @Override
    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        Leaf clusters;
        if (node == null || !node.hasChildren()) {
            return null;
        }
        LinkedList<SvdDMNode> list = new LinkedList<SvdDMNode>();
        Leaf group = ((Node)node).findChild("registers");
        if (group != null && group.hasChildren()) {
            for (Leaf child : ((Node)group).getChildren()) {
                if (child.isType("register")) {
                    list.add(new SvdRegisterDMNode(child));
                    continue;
                }
                if (!child.isType("cluster")) continue;
                list.add(new SvdClusterDMNode(child));
            }
        }
        if ((clusters = ((Node)node).findChild("clusters")) != null && clusters.hasChildren()) {
            for (Leaf child : ((Node)clusters).getChildren()) {
                if (!child.isType("cluster")) continue;
                list.add(new SvdClusterDMNode(child));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        SvdObjectDMNode[] array = list.toArray(new SvdObjectDMNode[list.size()]);
        return array;
    }

    @Override
    protected Leaf findDerivedFromNode() {
        String derivedFromName = this.getNode().getPropertyOrNull("derivedFrom");
        final SvdDerivedFromPath path = SvdDerivedFromPath.createPeripheralPath(derivedFromName);
        if (path == null) {
            return null;
        }
        Node root = this.getNode().getParent();
        while (!root.isType("device")) {
            root = root.getParent();
        }
        AbstractTreePreOrderIterator peripheralNodes = new AbstractTreePreOrderIterator(){

            public boolean isIterable(Leaf node) {
                if (node.isType("peripherals")) {
                    return true;
                }
                if (node.isType("peripheral")) {
                    return path.peripheralName.equals(node.getName());
                }
                return false;
            }

            public boolean isLeaf(Leaf node) {
                return node.isType("peripheral");
            }
        };
        peripheralNodes.setTreeNode((Leaf)root);
        Leaf ret = null;
        for (Leaf node : peripheralNodes) {
            if (!node.isType("peripheral")) continue;
            if (ret == null) {
                ret = node;
                continue;
            }
            Activator.log((String)("Non unique SVD path " + path));
        }
        return ret;
    }

    public String getId() {
        return this.getHexAddress();
    }

    @Override
    public BigInteger getBigSizeBytes() {
        String size = this.getAddressBlockSizeElement(this.getNode());
        if (size == null && this.getDerivedFromNode() != null) {
            size = this.getAddressBlockSizeElement(this.getDerivedFromNode());
        }
        if (size != null) {
            return SvdUtils.parseScaledNonNegativeBigInteger(size);
        }
        return null;
    }

    private String getAddressBlockSizeElement(Leaf node) {
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            if (node.hasChildren()) {
                for (Leaf child : ((Node)node).getChildren()) {
                    String usage;
                    if (!child.isType("addressBlock") || !"registers".equals(usage = child.getProperty("usage", ""))) continue;
                    return child.getProperty("size", null);
                }
            }
            return null;
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            return this.getNode().getProperty("size", "32");
        }
        return null;
    }

    @Override
    public BigInteger getBigAbsoluteAddress() {
        if (this.fBigAbsoluteAddress == null) {
            this.fBigAbsoluteAddress = SvdUtils.parseScaledNonNegativeBigInteger(this.getBaseAddress());
        }
        return this.fBigAbsoluteAddress;
    }

    public String getHexAddress() {
        if (this.fHexAddress == null) {
            this.fHexAddress = String.format("0x%08X", this.getBigAbsoluteAddress().longValue());
        }
        return this.fHexAddress;
    }

    public String getBaseAddress() {
        return this.getNode().getProperty("baseAddress", "0");
    }

    public boolean isSystem() {
        if (this.fIsSystem == null) {
            BigInteger addr = this.getBigAbsoluteAddress();
            this.fIsSystem = addr.compareTo(fSystemLimit) >= 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.fIsSystem;
    }

    public String getGroupName() {
        if (this.fGroupName == null) {
            this.fGroupName = this.getPropertyWithDerived("groupName");
        }
        return this.fGroupName;
    }

    public String getVersion() {
        if (this.fVersion == null) {
            this.fVersion = this.getPropertyWithDerived("version");
        }
        return this.fVersion;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getDisplayName() + ", " + this.getBaseAddress() + ", " + this.getBigSizeBytes() + ", " + this.getAccess() + ", \"" + this.getDescription() + "\"]";
    }
}

