/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.data.TaskAttributeDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.compare.Messages;
import org.eclipse.mylyn.tasks.core.data.ITaskAttributeDiff;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.swt.graphics.Image;

public class TaskDataDiffNode
extends DiffNode {
    public TaskDataDiffNode(int change, TaskData oldData, TaskData newData) {
        super(change);
        TaskDataDiff diff = new TaskDataDiff(TasksUiPlugin.getRepositoryModel(), newData, oldData);
        for (ITaskAttributeDiff attribute : diff.getChangedAttributes()) {
            TaskAttributeDiff attr = (TaskAttributeDiff)attribute;
            String label = attr.getLabel();
            if (label.endsWith(":")) {
                label = label.substring(0, label.length() - 1);
            }
            DiffNode node = new DiffNode(3, (ITypedElement)this, (ITypedElement)new ByteArrayInput(attr.getOldValues().toString(), null), (ITypedElement)new ByteArrayInput(attr.getNewValues().toString(), label));
            this.add((IDiffElement)node);
        }
        for (ITaskAttributeDiff attribute : diff.getNewComments()) {
            DiffNode node = new DiffNode(3, (ITypedElement)this, (ITypedElement)new ByteArrayInput("", null), (ITypedElement)new ByteArrayInput(attribute.getText(), Messages.TaskDataDiffNode_New_Comment_Label));
            this.add((IDiffElement)node);
        }
    }

    static class ByteArrayInput
    implements ITypedElement,
    IStreamContentAccessor {
        String content;
        private final String name;

        public ByteArrayInput(String content, String name) {
            this.content = content;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.content.getBytes());
        }
    }
}

