/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.htmlcss;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.html.core.internal.htmlcss.AbstractStyleSheetAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.HTMLDocumentAdapter;
import org.eclipse.wst.html.core.internal.htmlcss.URLHelper;
import org.eclipse.wst.html.core.internal.htmlcss.URLModelProvider;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LinkElementAdapter
extends AbstractStyleSheetAdapter {
    private static final String CSS_ID = ContentTypeIdForCSS.ContentTypeID_CSS;
    private boolean replaceModel = true;
    private final Class ModelProvideAdapterClass = IModelProvideAdapter.class;

    protected LinkElementAdapter() {
    }

    private void attrReplaced() {
        this.replaceModel = true;
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            return;
        }
        INodeNotifier notifier = (INodeNotifier)document;
        HTMLDocumentAdapter adapter = (HTMLDocumentAdapter)notifier.getAdapterFor(IStyleSheetListAdapter.class);
        if (adapter == null) {
            return;
        }
        adapter.childReplaced();
    }

    @Override
    protected ICSSModel createModel() {
        String absurl;
        if (this.getElement() == null) {
            return null;
        }
        IDOMModel baseModel = ((IDOMNode)this.getElement()).getModel();
        ICSSModel newModel = (ICSSModel)baseModel.getModelManager().createUnManagedStructuredModelFor(CSS_ID);
        URIResolver resolver = baseModel.getResolver();
        String ref = this.getElement().getAttribute("href");
        String string = absurl = resolver != null && ref != null && ref.length() > 0 ? resolver.getLocationByURI(ref, true) : null;
        if (absurl == null || absurl.length() == 0) {
            Path basePath = new Path(baseModel.getBaseLocation());
            URLHelper helper = new URLHelper(basePath.removeLastSegments(1).toString());
            absurl = helper.toAbsolute(ref == null ? "" : ref);
        }
        if (absurl == null || absurl.length() == 0) {
            absurl = ref;
        }
        if (absurl == null) {
            absurl = "";
        }
        newModel.setBaseLocation(absurl);
        newModel.addStyleListener((ICSSStyleListener)this);
        return newModel;
    }

    public ICSSModel getModel() {
        ICSSModel model = this.getExistingModel();
        if (this.replaceModel) {
            ICSSModel oldModel = model;
            try {
                IModelProvideAdapter adapter;
                model = this.retrieveModel();
                this.setModel(model);
                if (oldModel != null && (adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class)) != null) {
                    adapter.modelRemoved((IStructuredModel)oldModel);
                }
            }
            finally {
                if (oldModel != null) {
                    oldModel.releaseFromRead();
                }
            }
            this.replaceModel = false;
        }
        return model;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (eventType != 1) {
            return;
        }
        Attr attr = (Attr)changedFeature;
        if (attr == null) {
            return;
        }
        String name = attr.getName();
        if (name.equalsIgnoreCase("rel") || name.equalsIgnoreCase("type") || name.equalsIgnoreCase("href")) {
            this.attrReplaced();
        }
    }

    public void refreshSheet() {
        if (!this.replaceModel) {
            this.removed();
            this.replaceModel = true;
            IDOMNode node = (IDOMNode)this.getElement();
            if (node != null) {
                node.notify(1, (Object)this.getElement().getAttributeNode("href"), null, null, node.getStartOffset());
            }
        }
    }

    @Override
    public void released() {
        ICSSModel model = this.getExistingModel();
        if (model != null) {
            try {
                IModelProvideAdapter adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class);
                this.setElement(null);
                this.setModel(null);
                if (adapter != null) {
                    adapter.modelReleased((IStructuredModel)model);
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
        this.replaceModel = false;
    }

    @Override
    public void removed() {
        ICSSModel model = this.getExistingModel();
        if (model != null) {
            try {
                this.setModel(null);
                IModelProvideAdapter adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class);
                if (adapter != null) {
                    adapter.modelRemoved((IStructuredModel)model);
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
        this.replaceModel = false;
    }

    @Override
    protected boolean isValidAttribute() {
        Element element = this.getElement();
        if (element == null) {
            return false;
        }
        if (!element.hasAttribute("rel") || !"stylesheet".equalsIgnoreCase(element.getAttribute("rel"))) {
            return false;
        }
        if (element.hasAttribute("type") && !"text/css".equalsIgnoreCase(element.getAttribute("type"))) {
            return false;
        }
        return element.hasAttribute("href") && element.getAttribute("href").length() != 0;
    }

    private ICSSModel retrieveModel() {
        IStructuredModel newModel;
        IModelProvideAdapter adapter;
        block10: {
            block9: {
                if (!this.isValidAttribute()) {
                    return null;
                }
                Element element = this.getElement();
                String href = element.getAttribute("href");
                IDOMModel baseModel = ((IDOMNode)element).getModel();
                if (baseModel == null) {
                    return null;
                }
                String id = baseModel.getId();
                if (!(id instanceof String)) {
                    return null;
                }
                adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor((Object)this.ModelProvideAdapterClass);
                URLModelProvider provider = new URLModelProvider();
                newModel = provider.getModelForRead((IStructuredModel)baseModel, href);
                if (newModel != null) break block9;
                return null;
            }
            if (newModel instanceof ICSSModel) break block10;
            newModel.releaseFromRead();
            return null;
        }
        try {
            if (adapter != null) {
                adapter.modelProvided(newModel);
            }
            return (ICSSModel)newModel;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    protected void setModel(ICSSModel model) {
        ICSSModel oldModel = this.getExistingModel();
        if (model == oldModel) {
            return;
        }
        super.setModel(model);
        if (this.replaceModel) {
            this.replaceModel = false;
        }
        if (oldModel != null) {
            oldModel.removeStyleListener((ICSSStyleListener)this);
        }
        if (model != null) {
            model.addStyleListener((ICSSStyleListener)this);
        }
    }
}

