/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.spi;

import java.nio.file.Path;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.FieldImplementor;
import org.eclipse.scout.sdk.core.typescript.model.spi.AbstractNodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public abstract class AbstractFieldSpi
extends AbstractNodeElementSpi<IField>
implements FieldSpi {
    private final ES6ClassSpi m_declaringClass;

    protected AbstractFieldSpi(NodeModuleSpi module, ES6ClassSpi declaringClass) {
        super(module);
        this.m_declaringClass = (ES6ClassSpi)Ensure.notNull((Object)declaringClass);
    }

    @Override
    public INodeElement.ExportType exportType() {
        return INodeElement.ExportType.NONE;
    }

    @Override
    public ES6ClassSpi declaringClass() {
        return this.m_declaringClass;
    }

    @Override
    protected Path resolveContainingFile() {
        return this.declaringClass().containingFile().orElse(null);
    }

    @Override
    protected IField createApi() {
        return new FieldImplementor(this);
    }
}

