/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.internal;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.model.api.AbstractNodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.typescript.model.api.IPackageJson;
import org.eclipse.scout.sdk.core.typescript.model.api.JsonPointer;
import org.eclipse.scout.sdk.core.typescript.model.api.query.DependencyQuery;
import org.eclipse.scout.sdk.core.typescript.model.spi.PackageJsonSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public class PackageJsonImplementor
extends AbstractNodeElement<PackageJsonSpi>
implements IPackageJson {
    private static final JsonPointer EXPORTS_IMPORT = JsonPointer.compile("/exports/./import");
    private static final JsonPointer EXPORTS = JsonPointer.compile("/exports/.");
    private final String m_name;
    private final String m_version;
    private final FinalValue<Optional<String>> m_main;
    private final FinalValue<Optional<CharSequence>> m_mainContent;

    public PackageJsonImplementor(PackageJsonSpi spi) {
        super(spi);
        this.m_name = Strings.notBlank((CharSequence)spi.getString("name")).orElse("unknown");
        this.m_version = Strings.notBlank((CharSequence)spi.getString("version")).orElse("0.0.0");
        this.m_main = new FinalValue();
        this.m_mainContent = new FinalValue();
    }

    protected static CharSequence loadContent(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try {
            return Strings.fromFile((Path)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Unable to read '{}'.", new Object[]{file, e});
        }
    }

    @Override
    public Path location() {
        return this.directory().resolve("package.json");
    }

    @Override
    public Path directory() {
        return ((PackageJsonSpi)this.spi()).containingDir();
    }

    @Override
    public Optional<Path> mainLocation() {
        return this.main().map(m -> this.directory().resolve((String)m).normalize());
    }

    @Override
    public Optional<String> main() {
        return (Optional)this.m_main.computeIfAbsentAndGet(this::computeMain);
    }

    @Override
    public Optional<CharSequence> mainContent() {
        return (Optional)this.m_mainContent.computeIfAbsentAndGet(() -> this.mainLocation().map(PackageJsonImplementor::loadContent));
    }

    protected Optional<String> computeMain() {
        String[] mainOverride;
        String indexFileName = "index";
        for (String override : mainOverride = new String[]{"src/" + indexFileName + ".ts", "src/" + indexFileName + ".js", "src/main/js/" + indexFileName + ".ts", "src/main/js/" + indexFileName + ".js"}) {
            if (!((PackageJsonSpi)this.spi()).existsFile(override)) continue;
            return Optional.of(override);
        }
        return this.findPropertyAsString(EXPORTS_IMPORT).or(() -> this.findPropertyAsString(EXPORTS)).or(() -> this.propertyAsString("module")).or(() -> this.propertyAsString("main"));
    }

    @Override
    public Optional<String> propertyAsString(String name) {
        return Optional.ofNullable(((PackageJsonSpi)this.spi()).getString(name));
    }

    @Override
    public Optional<String> findPropertyAsString(JsonPointer pointer) {
        return this.findProperty(pointer, String.class);
    }

    @Override
    public Optional<Boolean> findPropertyAsBoolean(JsonPointer pointer) {
        return this.findProperty(pointer, Boolean.class);
    }

    @Override
    public Optional<BigDecimal> findPropertyAsNumber(JsonPointer pointer) {
        return this.findProperty(pointer, BigDecimal.class);
    }

    @Override
    public Optional<List<Object>> findPropertyAsArray(JsonPointer pointer) {
        return this.findProperty(pointer, List.class).map(m -> m);
    }

    @Override
    public Optional<Map<String, Object>> findPropertyAsObject(JsonPointer pointer) {
        return this.findProperty(pointer, Map.class).map(m -> m);
    }

    public <T> Optional<T> findProperty(JsonPointer pointer, Class<T> type) {
        return Optional.ofNullable(((PackageJsonSpi)this.spi()).find(pointer)).filter(a -> type.isAssignableFrom(a.getClass())).map(type::cast);
    }

    @Override
    public String version() {
        return this.m_version;
    }

    @Override
    public String name() {
        return this.m_name;
    }

    @Override
    public DependencyQuery dependencies() {
        return new DependencyQuery(((PackageJsonSpi)this.spi()).containingModule());
    }

    @Override
    public Optional<INodeModule> dependency(String name) {
        return this.dependencies().withName(name).first();
    }

    public String toString() {
        return this.name() + "@" + this.version();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageJsonImplementor that = (PackageJsonImplementor)o;
        return this.m_name.equals(that.m_name) && this.m_version.equals(that.m_version);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_version);
    }
}

