/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.builder.imports;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.sdk.core.typescript.builder.imports.ES6ImportCollector;
import org.eclipse.scout.sdk.core.typescript.builder.imports.IES6ImportCollector;
import org.eclipse.scout.sdk.core.typescript.builder.imports.IES6ImportValidator;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeNameEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;

public class ES6ImportValidator
implements IES6ImportValidator {
    private static final Collection<String> IGNORE_TYPES = new HashSet<String>(Arrays.asList("any", "unknown", "never", "void", "object", "IArguments", "Date", "RegExp", "Error", "Array", "PromiseLike", "Promise", "ArrayLike", "Partial", "Required", "Readonly", "Pick", "Record", "Exclude", "Extract", "Omit", "NonNullable", "this", "ThisType"));
    private IES6ImportCollector m_collector = new ES6ImportCollector();

    @Override
    public CharSequence use(IDataType dataType) {
        return new UniqueNameEvaluator().eval(dataType);
    }

    public static boolean isBuiltInType(String name) {
        return IGNORE_TYPES.contains(name);
    }

    protected String computeUniqueNameAndRegisterUsage(IDataType type) {
        IES6ImportCollector collector;
        Set<String> usedNamesForSource;
        String name = type.name();
        if (type.isPrimitive()) {
            return name;
        }
        if (ES6ImportValidator.isBuiltInType(name)) {
            return name;
        }
        if (type instanceof IES6Class) {
            IES6Class es6Class = (IES6Class)type;
            type = es6Class.withoutTypeArguments();
        }
        if (!(usedNamesForSource = (collector = this.importCollector()).usedNames()).contains(name)) {
            return collector.add(type, null).nameForSource();
        }
        IES6ImportCollector.ES6ImportDescriptor existing = collector.descriptorFor(type);
        if (existing != null) {
            return existing.nameForSource();
        }
        String newAlias = ES6ImportValidator.getUniqueAlias(name, usedNamesForSource);
        return collector.add(type, newAlias).nameForSource();
    }

    public static String getUniqueAlias(String origName, Collection<String> usedNames) {
        Object uniqueName = origName;
        int counter = 0;
        do {
            uniqueName = origName + counter;
            ++counter;
        } while (usedNames.contains(uniqueName));
        return uniqueName;
    }

    @Override
    public IES6ImportCollector importCollector() {
        return this.m_collector;
    }

    public void setImportCollector(IES6ImportCollector collector) {
        this.m_collector = collector;
    }

    private class UniqueNameEvaluator
    extends DataTypeNameEvaluator {
        private UniqueNameEvaluator() {
        }

        @Override
        protected String nameForLeafType(IDataType type) {
            return ES6ImportValidator.this.computeUniqueNameAndRegisterUsage(type);
        }
    }
}

