/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.apidef;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.apidef.MaxApiLevel;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ApiVersion
implements Comparable<ApiVersion> {
    public static final ApiVersion LATEST = new ApiVersion(Integer.MAX_VALUE);
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(\\.(\\d*))?(\\.(\\d*))?([-.].*)?");
    private final int[] m_segments;
    private final String m_suffix;

    public ApiVersion(int ... version) {
        this(version, null);
    }

    public ApiVersion(String suffix, int ... version) {
        this(version, suffix);
    }

    public ApiVersion(int[] version, String suffix) {
        Ensure.isTrue((((int[])Ensure.notNull((Object)version)).length > 0 ? 1 : 0) != 0);
        this.m_segments = Arrays.copyOf(version, version.length);
        this.m_suffix = suffix;
    }

    public static Optional<ApiVersion> maxApiLevelOf(Class<?> clazz) {
        return Optional.ofNullable(clazz).map(c -> c.getAnnotation(MaxApiLevel.class)).map(MaxApiLevel::value).map(ApiVersion::new);
    }

    public static ApiVersion requireMaxApiLevelOf(Class<?> clazz) {
        return ApiVersion.maxApiLevelOf(clazz).orElseThrow(() -> Ensure.newFail((CharSequence)"{} is missing required annotation '{}'.", (Object[])new Object[]{clazz, MaxApiLevel.class.getName()}));
    }

    public static Optional<ApiVersion> parse(CharSequence version) {
        if (Strings.isBlank((CharSequence)version)) {
            return Optional.empty();
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int[] segments = Stream.of(1, 3, 5).map(matcher::group).filter(Strings::hasText).mapToInt(Integer::parseInt).toArray();
        String suffix = matcher.group(6);
        return Optional.of(new ApiVersion(segments, suffix));
    }

    public String suffix() {
        return this.m_suffix;
    }

    public int[] segments() {
        return this.segments(this.m_segments.length);
    }

    public int[] segments(int n) {
        return Arrays.copyOf(this.m_segments, Math.max(0, Math.min(n, this.m_segments.length)));
    }

    public int major() {
        return this.m_segments[0];
    }

    public String asString() {
        String numberPart = Arrays.stream(this.m_segments).mapToObj(Integer::toString).collect(Collectors.joining("."));
        String suffix = this.suffix();
        if (Strings.isEmpty((CharSequence)suffix)) {
            return numberPart;
        }
        return numberPart + suffix;
    }

    public String toString() {
        return ApiVersion.class.getSimpleName() + " " + this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiVersion that = (ApiVersion)o;
        return Arrays.equals(this.m_segments, that.m_segments) && Objects.equals(this.m_suffix, that.m_suffix);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.m_segments) + (this.m_suffix != null ? this.m_suffix.hashCode() : 0);
    }

    public int compareCommonSegmentsTo(ApiVersion o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        int numSegments = Math.min(o.m_segments.length, this.m_segments.length);
        for (int i = 0; i < numSegments; ++i) {
            int dif = Integer.compare(this.m_segments[i], o.m_segments[i]);
            if (dif == 0) continue;
            return dif;
        }
        if (o.m_segments.length != this.m_segments.length) {
            return 0;
        }
        return Comparator.nullsLast(String::compareTo).compare(this.suffix(), o.suffix());
    }

    @Override
    public int compareTo(ApiVersion o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        int numSegments = Math.max(o.m_segments.length, this.m_segments.length);
        for (int i = 0; i < numSegments; ++i) {
            int other;
            int me = ApiVersion.positionValue(this.m_segments, i);
            int dif = Integer.compare(me, other = ApiVersion.positionValue(o.m_segments, i));
            if (dif == 0) continue;
            return dif;
        }
        return Comparator.nullsLast(String::compareTo).compare(this.suffix(), o.suffix());
    }

    private static int positionValue(int[] arr, int index) {
        if (index >= arr.length) {
            return Integer.MAX_VALUE;
        }
        return arr[index];
    }
}

