/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.extension.ContentGeneratorExtensionFactoryRegistry;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Binding;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11EndPoint;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLAdapterFactoryHelper;

public class W11SetBindingCommand
extends W11TopLevelElementCommand {
    private Port port;
    private Binding binding;

    public W11SetBindingCommand(Port port, Binding binding) {
        super(Messages._UI_ACTION_SET_BINDING, port.getEnclosingDefinition());
        this.port = port;
        this.binding = binding;
    }

    @Override
    public void execute() {
        try {
            this.beginRecording(this.port.getElement());
            this.port.setEBinding(this.binding);
            W11SetBindingCommand.updatePortProtocol(this.port, this.binding);
        }
        finally {
            this.endRecording(this.port.getElement());
        }
    }

    public static void updatePortProtocol(Port port, Binding binding) {
        W11EndPoint portProtocol;
        String bindingProtocol = W11SetBindingCommand.getBindingProtocol(binding);
        if (!(bindingProtocol == null || (portProtocol = W11SetBindingCommand.getPortProtocol(port)) != null && bindingProtocol.equals(portProtocol.getProtocol()))) {
            ContentGeneratorExtensionFactoryRegistry factoryRegistry;
            ContentGenerator contentGenerator;
            String portAddress = null;
            if (portProtocol != null) {
                portAddress = portProtocol.getAddress();
            }
            if (portAddress == null) {
                portAddress = "http://www.example.org";
            }
            if ((contentGenerator = (factoryRegistry = ContentGeneratorExtensionFactoryRegistry.getInstance()).getGeneratorClassFromName(bindingProtocol)) != null) {
                contentGenerator.setAddressLocation(portAddress);
                contentGenerator.generatePortContent(port);
            }
        }
    }

    private static String getBindingProtocol(Binding binding) {
        Binding notifier = binding;
        Adapter adapter = WSDLAdapterFactoryHelper.getInstance().adapt((Notifier)notifier);
        if (adapter instanceof W11Binding) {
            return ((W11Binding)adapter).getProtocol();
        }
        return null;
    }

    private static W11EndPoint getPortProtocol(Port port) {
        Port notifier = port;
        Adapter adapter = WSDLAdapterFactoryHelper.getInstance().adapt((Notifier)notifier);
        if (adapter instanceof W11EndPoint) {
            return (W11EndPoint)adapter;
        }
        return null;
    }
}

