/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.testcase;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.CommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.java.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.util.Strings;

public class TestGenerator<TYPE extends TestGenerator<TYPE>>
extends PrimaryTypeGenerator<TYPE> {
    private String m_runner;
    private ApiFunction<?, ITypeNameSupplier> m_session;
    private ISourceGenerator<IExpressionBuilder<?>> m_runWithSubjectValueGenerator;
    private boolean m_isClientTest;

    protected void setup() {
        ((TestGenerator)this.withField((IFieldGenerator)new TodoCommentBuilder(), new Object[0])).withAnnotation(ScoutAnnotationGenerator.createRunWithSubject(this.runWithSubjectValueGenerator()));
        this.runner().map(ScoutAnnotationGenerator::createRunWith).ifPresent(arg_0 -> ((TestGenerator)this).withAnnotation(arg_0));
        if (this.isClientTest()) {
            this.withAnnotation(ScoutAnnotationGenerator.createRunWithClientSession(this.session().orElse(null)));
        } else {
            this.session().map(ScoutAnnotationGenerator::createRunWithServerSession).ifPresent(arg_0 -> ((TestGenerator)this).withAnnotation(arg_0));
        }
    }

    public Optional<String> runner() {
        return Strings.notBlank((CharSequence)this.m_runner);
    }

    public TYPE withRunner(String runner) {
        this.m_runner = runner;
        return (TYPE)((Object)((TestGenerator)this.thisInstance()));
    }

    public Optional<ApiFunction<?, ITypeNameSupplier>> session() {
        return Optional.ofNullable(this.m_session);
    }

    public TYPE withSession(CharSequence session) {
        return this.withSessionFrom(null, api -> ITypeNameSupplier.of((CharSequence)session));
    }

    public <API extends IApiSpecification> TYPE withSessionFrom(Class<API> apiSpec, Function<API, ITypeNameSupplier> sessionFunction) {
        this.m_session = sessionFunction == null ? null : new ApiFunction(apiSpec, sessionFunction);
        return (TYPE)((Object)((TestGenerator)this.thisInstance()));
    }

    public boolean isClientTest() {
        return this.m_isClientTest;
    }

    public TYPE asClientTest(boolean isClientTest) {
        this.m_isClientTest = isClientTest;
        return (TYPE)((Object)((TestGenerator)this.thisInstance()));
    }

    public ISourceGenerator<IExpressionBuilder<?>> runWithSubjectValueGenerator() {
        return this.m_runWithSubjectValueGenerator;
    }

    public TYPE withRunWithSubjectValueBuilder(ISourceGenerator<IExpressionBuilder<?>> runWithSubjectValueGenerator) {
        this.m_runWithSubjectValueGenerator = runWithSubjectValueGenerator;
        return (TYPE)((Object)((TestGenerator)this.thisInstance()));
    }

    private static final class TodoCommentBuilder
    extends FieldGenerator<TodoCommentBuilder> {
        private TodoCommentBuilder() {
            this.withElementName("todo");
        }

        protected void build(IJavaSourceBuilder<?> builder) {
            CommentBuilder.create(builder).appendTodo((CharSequence)"add test cases");
        }
    }
}

