/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dto;

import java.beans.Introspector;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.MethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.java.model.api.PropertyBean;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.s.dto.DtoMemberSortObjectFactory;
import org.eclipse.scout.sdk.core.s.java.annotation.DataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.java.annotation.ExtendsAnnotation;
import org.eclipse.scout.sdk.core.s.java.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.java.annotation.ReplaceAnnotation;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.java.builder.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.IScoutMethodGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.ScoutMethodGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractDtoGenerator<TYPE extends AbstractDtoGenerator<TYPE>>
extends TypeGenerator<TYPE> {
    public static final String FORMDATA_CLASSID_SUFFIX = "-formdata";
    private final IType m_modelType;
    private final IJavaEnvironment m_targetEnvironment;
    private final IScoutApi m_scoutApi;
    private IJavaSourceBuilder<?> m_currentBuilder;

    protected AbstractDtoGenerator(IType modelType, IJavaEnvironment targetEnvironment) {
        this.m_modelType = (IType)Ensure.notNull((Object)modelType);
        this.m_targetEnvironment = (IJavaEnvironment)Ensure.notNull((Object)targetEnvironment);
        this.m_scoutApi = (IScoutApi)modelType.javaEnvironment().requireApi(IScoutApi.class);
    }

    protected void build(IJavaSourceBuilder<?> builder) {
        this.m_currentBuilder = builder;
        try {
            this.setupBuilder();
            super.build(builder);
        }
        finally {
            this.m_currentBuilder = null;
        }
    }

    public IScoutApi scoutApi() {
        return this.m_scoutApi;
    }

    protected IJavaSourceBuilder<?> currentBuilder() {
        return this.m_currentBuilder;
    }

    protected void copyAnnotations() {
        AbstractDtoGenerator.copyAnnotations((IAnnotatable)this.modelType(), this, this.targetEnvironment());
    }

    private static void copyAnnotations(IAnnotatable annotationOwner, ITypeGenerator<?> target, IJavaEnvironment targetEnv) {
        IScoutApi scoutApi = (IScoutApi)annotationOwner.javaEnvironment().requireApi(IScoutApi.class);
        annotationOwner.annotations().stream().filter(a -> AbstractDtoGenerator.isAnnotationDtoRelevant(a.type(), scoutApi)).filter(a -> targetEnv.exists(a.type())).map(AbstractDtoGenerator::toDtoAnnotationGenerator).forEach(arg_0 -> target.withAnnotation(arg_0));
    }

    private static IAnnotationGenerator<?> toDtoAnnotationGenerator(IAnnotation a) {
        IAnnotationGenerator result = a.toWorkingCopy();
        IScoutAnnotationApi.ClassId classIdApi = ((IScoutApi)a.javaEnvironment().requireApi(IScoutApi.class)).ClassId();
        if (classIdApi.fqn().equals(a.type().name())) {
            String valueElementName = classIdApi.valueElementName();
            String id = (String)((IAnnotationElement)a.element(valueElementName).orElseThrow()).value().as(String.class);
            result.withElement(valueElementName, b -> b.stringLiteral((CharSequence)(id + FORMDATA_CLASSID_SUFFIX)));
        }
        return result;
    }

    private static boolean isAnnotationDtoRelevant(IType annotationType, IScoutAnnotationApi scoutApi) {
        if (annotationType == null) {
            return false;
        }
        String elementName = annotationType.name();
        boolean isDtoAnnotation = elementName.equals(scoutApi.FormData().fqn()) || elementName.equals(scoutApi.PageData().fqn()) || elementName.equals(scoutApi.Data().fqn());
        return !isDtoAnnotation && !elementName.equals(scoutApi.Order().fqn()) && annotationType.annotations().withName((CharSequence)scoutApi.DtoRelevant().fqn()).existsAny();
    }

    protected TYPE withAdditionalInterfaces(FormDataAnnotationDescriptor formDataAnnotation) {
        Set<IType> interfaces = formDataAnnotation.getInterfaces();
        if (interfaces.isEmpty()) {
            return (TYPE)((Object)((AbstractDtoGenerator)this.thisInstance()));
        }
        IJavaEnvironment javaEnvironment = this.targetEnvironment();
        Set allSuperInterfaceMethods = interfaces.stream().filter(arg_0 -> ((IJavaEnvironment)javaEnvironment).exists(arg_0)).peek(ifcType -> this.withInterface(ifcType.reference())).flatMap(ifcType -> ifcType.methods().withSuperTypes(true).stream()).map(IMethod::identifier).collect(Collectors.toSet());
        this.methods().filter(msb -> allSuperInterfaceMethods.contains(msb.identifier(this.currentBuilder().context()))).forEach(msb -> msb.withAnnotation(AnnotationGenerator.createOverride()));
        return (TYPE)((Object)((AbstractDtoGenerator)this.thisInstance()));
    }

    protected TYPE withExtendsAnnotationIfNecessary(IType element) {
        Optional<IType> extendedTypeOpt = this.getExtendedType(element);
        if (extendedTypeOpt.isEmpty()) {
            return (TYPE)((Object)((AbstractDtoGenerator)this.thisInstance()));
        }
        IType extendedType = extendedTypeOpt.orElseThrow();
        IType primaryType = extendedType.primary();
        Optional<Object> extendedDto = Optional.empty();
        IScoutApi api = this.scoutApi();
        if (primaryType.isInstanceOf((ITypeNameSupplier)api.IForm()) || primaryType.isInstanceOf((ITypeNameSupplier)api.IFormField())) {
            Optional declaring = extendedType.declaringType();
            if (extendedType.isInstanceOf((ITypeNameSupplier)api.ITable()) && declaring.isPresent()) {
                Optional<IType> tableFieldDto = AbstractDtoGenerator.getFormDataType((IType)declaring.orElseThrow());
                extendedDto = tableFieldDto.flatMap(dto -> ((HierarchyInnerTypeQuery)dto.innerTypes().withInstanceOf((ITypeNameSupplier)api.AbstractTableRowData())).first());
            } else {
                extendedDto = AbstractDtoGenerator.findDtoForForm(primaryType);
            }
        } else if (primaryType.isInstanceOf((ITypeNameSupplier)api.IExtension())) {
            extendedDto = AbstractDtoGenerator.findDtoForPage(primaryType);
        } else if (primaryType.isInstanceOf((ITypeNameSupplier)api.IPageWithTable())) {
            Optional<IType> pageDto = AbstractDtoGenerator.findDtoForPage(primaryType);
            extendedDto = pageDto.flatMap(dto -> ((HierarchyInnerTypeQuery)dto.innerTypes().withInstanceOf((ITypeNameSupplier)api.AbstractTableRowData())).first());
        }
        AbstractDtoGenerator abstractDtoGenerator = this;
        return (TYPE)((Object)extendedDto.map(t -> (AbstractDtoGenerator)this.withAnnotation(ScoutAnnotationGenerator.createExtends(t.reference()))).orElseGet(() -> (AbstractDtoGenerator)abstractDtoGenerator.thisInstance()));
    }

    private static Optional<IType> findDtoForForm(IType form) {
        if (form == null) {
            return Optional.empty();
        }
        FormDataAnnotationDescriptor a = FormDataAnnotationDescriptor.of(form);
        return Optional.ofNullable(a.getFormDataType());
    }

    private static Optional<IType> findDtoForPage(IType page) {
        if (page == null) {
            return Optional.empty();
        }
        return DataAnnotationDescriptor.of(page).map(DataAnnotationDescriptor::getDataType);
    }

    protected static String getRowDataName(String base) {
        if (Strings.isBlank((CharSequence)base)) {
            return "RowData";
        }
        StringBuilder result = new StringBuilder(base.length() + "RowData".length());
        String[] suffixes = new String[]{"PageData", "FieldData", "Data"};
        Arrays.stream(suffixes).filter(base::endsWith).findFirst().ifPresent(suffix -> result.append(base, 0, base.length() - suffix.length()));
        if (result.isEmpty()) {
            result.append(base);
        }
        return result.append("RowData").toString();
    }

    protected static String removeFieldSuffix(String fieldName) {
        if (fieldName.endsWith("Field")) {
            return fieldName.substring(0, fieldName.length() - "Field".length());
        }
        if (fieldName.endsWith("Button")) {
            return fieldName.substring(0, fieldName.length() - "Button".length());
        }
        if (fieldName.endsWith("Column")) {
            return fieldName.substring(0, fieldName.length() - "Column".length());
        }
        if (fieldName.endsWith("Page")) {
            return fieldName.substring(0, fieldName.length() - "Page".length());
        }
        return fieldName;
    }

    private static Optional<IType> getFormDataType(IType modelType) {
        IType primaryType = AbstractDtoGenerator.getFormFieldDataPrimaryTypeRec(modelType);
        if (primaryType == null) {
            return Optional.empty();
        }
        boolean isPrimaryType = modelType.declaringType().isEmpty();
        if (isPrimaryType) {
            return Optional.of(primaryType);
        }
        String formDataName = AbstractDtoGenerator.removeFieldSuffix(modelType.elementName());
        if (primaryType.elementName().equals(formDataName)) {
            return Optional.of(primaryType);
        }
        return ((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)primaryType.innerTypes().withRecursiveInnerTypes(true)).withSimpleName((CharSequence)formDataName)).first();
    }

    private static Optional<IType> computeDtoGenericType(IType contextType, IType annotationOwnerType, int genericOrdinal) {
        if (contextType == null || Object.class.getName().equals(contextType.name()) || annotationOwnerType == null) {
            return Optional.empty();
        }
        if (annotationOwnerType.typeArguments().count() <= (long)genericOrdinal) {
            ITypeParameter param = (ITypeParameter)annotationOwnerType.typeParameters().skip(genericOrdinal).findAny().orElseThrow(() -> new SdkException((CharSequence)"Invalid genericOrdinal value on class '{}': {}.", new Object[]{annotationOwnerType.name(), genericOrdinal}));
            return param.bounds().findAny();
        }
        return annotationOwnerType.resolveTypeParamValue(genericOrdinal).flatMap(Stream::findFirst);
    }

    private static IType getFormFieldDataPrimaryTypeRec(IType recursiveDeclaringType) {
        while (recursiveDeclaringType != null) {
            FormDataAnnotationDescriptor formDataAnnotation = FormDataAnnotationDescriptor.of(recursiveDeclaringType);
            if (FormDataAnnotationDescriptor.isIgnore(formDataAnnotation)) {
                return null;
            }
            Optional declaringType = recursiveDeclaringType.declaringType();
            if (declaringType.isEmpty()) {
                if (FormDataAnnotationDescriptor.isCreate(formDataAnnotation) || FormDataAnnotationDescriptor.isSdkCommandUse(formDataAnnotation)) {
                    return formDataAnnotation.getFormDataType();
                }
                return null;
            }
            recursiveDeclaringType = (IType)declaringType.orElseThrow();
        }
        return null;
    }

    protected static String computeSuperTypeForFormData(IType modelType, FormDataAnnotationDescriptor formDataAnnotation) {
        Optional<String> replaced;
        if (modelType.annotations().withManagedWrapper(ReplaceAnnotation.class).existsAny() && (replaced = modelType.superClass().flatMap(AbstractDtoGenerator::getFormDataType).map(IType::reference)).isPresent()) {
            return replaced.orElseThrow();
        }
        return AbstractDtoGenerator.computeSuperTypeForFormDataIgnoringReplace(modelType, formDataAnnotation);
    }

    private static String computeSuperTypeForFormDataIgnoringReplace(IType formField, FormDataAnnotationDescriptor formDataAnnotation) {
        Optional<IType> genericType;
        IType genericOrdinalDefinitionType;
        IType superType = formDataAnnotation.getSuperType();
        if (superType == null) {
            return null;
        }
        if (formDataAnnotation.getGenericOrdinal() >= 0 && (genericOrdinalDefinitionType = formDataAnnotation.getGenericOrdinalDefinitionType()) != null && superType.hasTypeParameters() && (genericType = AbstractDtoGenerator.computeDtoGenericType(formField, genericOrdinalDefinitionType, formDataAnnotation.getGenericOrdinal())).isPresent()) {
            return genericType.map(IType::reference).map(fqn -> superType.name() + "<" + fqn + ">").orElseThrow();
        }
        return superType.reference();
    }

    private static Optional<IType> findExtendsAnnotationValue(IType element) {
        return element.superTypes().withSuperInterfaces(false).stream().flatMap(curType -> curType.annotations().withManagedWrapper(ExtendsAnnotation.class).first().stream()).map(ExtendsAnnotation::value).findAny();
    }

    private Optional<IType> getExtendedType(IType modelType) {
        Optional owner;
        if (modelType == null) {
            return Optional.empty();
        }
        Optional<IType> extendsValue = AbstractDtoGenerator.findExtendsAnnotationValue(modelType);
        if (extendsValue.isPresent()) {
            return extendsValue;
        }
        IScoutInterfaceApi.IExtension iExtension = this.scoutApi().IExtension();
        if (modelType.isInstanceOf((ITypeNameSupplier)iExtension) && (owner = modelType.resolveTypeParamValue(iExtension.ownerTypeParamIndex(), iExtension.fqn())).isPresent()) {
            return ((Stream)owner.orElseThrow()).findFirst();
        }
        return modelType.declaringType().flatMap(this::getExtendedType);
    }

    protected void setupBuilder() {
        ((AbstractDtoGenerator)((AbstractDtoGenerator)this.asPublic()).withSuperClass(this.computeSuperType())).withField(FieldGenerator.createSerialVersionUid(), new Object[0]);
        if (this.declaringGenerator().orElse(null) instanceof ITypeGenerator) {
            this.asStatic();
        }
        if (Flags.isAbstract((int)this.modelType().flags())) {
            this.asAbstract();
        }
        this.copyAnnotations();
    }

    protected TYPE withReplaceIfNecessary() {
        if (this.modelType().annotations().withManagedWrapper(ReplaceAnnotation.class).existsAny()) {
            this.withAnnotation(ScoutAnnotationGenerator.createReplace());
        }
        return (TYPE)((Object)((AbstractDtoGenerator)this.thisInstance()));
    }

    protected abstract String computeSuperType();

    public IType modelType() {
        return this.m_modelType;
    }

    protected static boolean hasDtoAnnotation(IAnnotatable method, IScoutAnnotationApi scoutApi) {
        String formDataFqn = scoutApi.FormData().fqn();
        String data = scoutApi.Data().fqn();
        return method.annotations().withName((CharSequence)formDataFqn).existsAny() || method.annotations().withName((CharSequence)data).existsAny();
    }

    protected TYPE withPropertyDtos() {
        IScoutApi scoutApi = this.scoutApi();
        PropertyBean.of((IType)this.modelType()).filter(bean -> bean.readMethod().isPresent() && bean.writeMethod().isPresent()).filter(bean -> AbstractDtoGenerator.hasDtoAnnotation((IAnnotatable)bean.readMethod().orElseThrow(), scoutApi) || AbstractDtoGenerator.hasDtoAnnotation((IAnnotatable)bean.writeMethod().orElseThrow(), scoutApi)).sorted(Comparator.comparing(PropertyBean::name).thenComparing(PropertyBean::toString)).forEach(this::addPropertyDto);
        return (TYPE)((Object)((AbstractDtoGenerator)this.thisInstance()));
    }

    private void addPropertyDto(PropertyBean desc) {
        String lowerCaseBeanName = Introspector.decapitalize(desc.name());
        String upperCaseBeanName = Strings.capitalize((CharSequence)desc.name()).toString();
        String propName = upperCaseBeanName + "Property";
        String propDataType = desc.type().reference();
        String propDataTypeBoxed = JavaTypes.boxPrimitive((CharSequence)propDataType);
        IScoutAbstractApi.AbstractPropertyData abstractPropertyDataApi = this.scoutApi().AbstractPropertyData();
        ITypeGenerator propertyTypeBuilder = ((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).asStatic()).withElementName(propName)).withSuperClass(abstractPropertyDataApi.fqn() + "<" + propDataTypeBoxed + ">").withField(FieldGenerator.createSerialVersionUid(), new Object[0]);
        AbstractDtoGenerator.copyAnnotations((IAnnotatable)desc.readMethod().orElseThrow(), propertyTypeBuilder, this.targetEnvironment());
        String getterName = "get" + propName;
        ((AbstractDtoGenerator)((AbstractDtoGenerator)((AbstractDtoGenerator)this.withType(propertyTypeBuilder, DtoMemberSortObjectFactory.forTypeFormDataProperty(propName))).withMethod(((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().asPublic()).withElementName(getterName)).withReturnType(propName)).withBody(b -> ((IScoutMethodBodyBuilder)b.returnClause()).appendGetPropertyByClass(propName).semicolon()), DtoMemberSortObjectFactory.forMethodFormDataProperty(upperCaseBeanName))).withMethod(((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asPublic()).withElementName(PropertyBean.getterPrefixFor((CharSequence)propDataType) + upperCaseBeanName)).withComment(b -> b.appendJavaDocComment("access method for property " + upperCaseBeanName + "."))).withReturnType(propDataType).withBody(b -> {
            String suffix = "()." + abstractPropertyDataApi.getValueMethodName() + "()";
            ((IMethodBodyBuilder)b.returnClause().append(getterName)).append(suffix);
            if (JavaTypes.isPrimitive((CharSequence)propDataType)) {
                ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.append(" == ")).nullLiteral()).append(" ? ")).appendDefaultValueOf((CharSequence)propDataTypeBoxed)).append(" : ")).append(getterName)).append(suffix);
            }
            b.semicolon();
        }), DtoMemberSortObjectFactory.forMethodFormDataPropertyLegacy(upperCaseBeanName))).withMethod(((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asPublic()).withElementName("set" + upperCaseBeanName)).withComment(b -> b.appendJavaDocComment("access method for property " + upperCaseBeanName + "."))).withReturnType("void").withParameter(((IMethodParameterGenerator)MethodParameterGenerator.create().withElementName(lowerCaseBeanName)).withDataType(propDataType)).withBody(b -> ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.append(getterName)).parenthesisOpen()).parenthesisClose()).dot()).append(abstractPropertyDataApi.setValueMethodName())).parenthesisOpen()).appendParameterName(0).parenthesisClose()).semicolon()), DtoMemberSortObjectFactory.forMethodFormDataPropertyLegacy(upperCaseBeanName));
    }

    public IJavaEnvironment targetEnvironment() {
        return this.m_targetEnvironment;
    }
}

