"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentProps = getComponentProps;
exports.getComponentEvents = getComponentEvents;
exports.getTemplateContextProps = getTemplateContextProps;
exports.getComponentNames = getComponentNames;
exports._getComponentNames = _getComponentNames;
exports.getElementAttrs = getElementAttrs;
const vue = require("@vue/language-core");
const shared_1 = require("@vue/shared");
function getComponentProps(fileName, tag) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof vue.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    const program = languageService.getProgram();
    const checker = program.getTypeChecker();
    const components = getVariableType(ts, languageService, vueCode, '__VLS_components');
    if (!components) {
        return [];
    }
    const name = tag.split('.');
    let componentSymbol = components.type.getProperty(name[0])
        ?? components.type.getProperty((0, shared_1.camelize)(name[0]))
        ?? components.type.getProperty((0, shared_1.capitalize)((0, shared_1.camelize)(name[0])));
    if (!componentSymbol) {
        return [];
    }
    let componentType = checker.getTypeOfSymbolAtLocation(componentSymbol, components.node);
    for (let i = 1; i < name.length; i++) {
        componentSymbol = componentType.getProperty(name[i]);
        if (componentSymbol) {
            componentType = checker.getTypeOfSymbolAtLocation(componentSymbol, components.node);
        }
        else {
            return [];
        }
    }
    const result = new Map();
    for (const sig of componentType.getCallSignatures()) {
        const propParam = sig.parameters[0];
        if (propParam) {
            const propsType = checker.getTypeOfSymbolAtLocation(propParam, components.node);
            const props = propsType.getProperties();
            for (const prop of props) {
                const name = prop.name;
                const required = !(prop.flags & ts.SymbolFlags.Optional) || undefined;
                const commentMarkdown = generateCommentMarkdown(prop.getDocumentationComment(checker), prop.getJsDocTags()) || undefined;
                result.set(name, { name, required, commentMarkdown });
            }
        }
    }
    for (const sig of componentType.getConstructSignatures()) {
        const instanceType = sig.getReturnType();
        const propsSymbol = instanceType.getProperty('$props');
        if (propsSymbol) {
            const propsType = checker.getTypeOfSymbolAtLocation(propsSymbol, components.node);
            const props = propsType.getProperties();
            for (const prop of props) {
                if (prop.flags & ts.SymbolFlags.Method) { // #2443
                    continue;
                }
                const name = prop.name;
                const required = !(prop.flags & ts.SymbolFlags.Optional) || undefined;
                const commentMarkdown = generateCommentMarkdown(prop.getDocumentationComment(checker), prop.getJsDocTags()) || undefined;
                result.set(name, { name, required, commentMarkdown });
            }
        }
    }
    return [...result.values()];
}
function getComponentEvents(fileName, tag) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof vue.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    const program = languageService.getProgram();
    const checker = program.getTypeChecker();
    const components = getVariableType(ts, languageService, vueCode, '__VLS_components');
    if (!components) {
        return [];
    }
    const name = tag.split('.');
    let componentSymbol = components.type.getProperty(name[0]);
    if (!componentSymbol) {
        componentSymbol = components.type.getProperty((0, shared_1.camelize)(name[0]))
            ?? components.type.getProperty((0, shared_1.capitalize)((0, shared_1.camelize)(name[0])));
    }
    if (!componentSymbol) {
        return [];
    }
    let componentType = checker.getTypeOfSymbolAtLocation(componentSymbol, components.node);
    for (let i = 1; i < name.length; i++) {
        componentSymbol = componentType.getProperty(name[i]);
        if (componentSymbol) {
            componentType = checker.getTypeOfSymbolAtLocation(componentSymbol, components.node);
        }
        else {
            return [];
        }
    }
    const result = new Set();
    // for (const sig of componentType.getCallSignatures()) {
    // 	const emitParam = sig.parameters[1];
    // 	if (emitParam) {
    // 		// TODO
    // 	}
    // }
    for (const sig of componentType.getConstructSignatures()) {
        const instanceType = sig.getReturnType();
        const emitSymbol = instanceType.getProperty('$emit');
        if (emitSymbol) {
            const emitType = checker.getTypeOfSymbolAtLocation(emitSymbol, components.node);
            for (const call of emitType.getCallSignatures()) {
                const eventNameParamSymbol = call.parameters[0];
                if (eventNameParamSymbol) {
                    const eventNameParamType = checker.getTypeOfSymbolAtLocation(eventNameParamSymbol, components.node);
                    if (eventNameParamType.isStringLiteral()) {
                        result.add(eventNameParamType.value);
                    }
                }
            }
        }
    }
    return [...result];
}
function getTemplateContextProps(fileName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof vue.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    return getVariableType(ts, languageService, vueCode, '__VLS_ctx')
        ?.type
        ?.getProperties()
        .map(c => c.name);
}
function getComponentNames(fileName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof vue.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    return getVariableType(ts, languageService, vueCode, '__VLS_components')
        ?.type
        ?.getProperties()
        .map(c => c.name)
        .filter(entry => !entry.includes('$') && !entry.startsWith('_'))
        ?? [];
}
function _getComponentNames(ts, tsLs, vueCode) {
    return getVariableType(ts, tsLs, vueCode, '__VLS_components')
        ?.type
        ?.getProperties()
        .map(c => c.name)
        .filter(entry => !entry.includes('$') && !entry.startsWith('_'))
        ?? [];
}
function getElementAttrs(fileName, tagName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof vue.VueVirtualCode)) {
        return;
    }
    const program = languageService.getProgram();
    let tsSourceFile;
    if (tsSourceFile = program.getSourceFile(fileName)) {
        const typeNode = tsSourceFile.statements.find((node) => ts.isTypeAliasDeclaration(node) && node.name.getText() === '__VLS_IntrinsicElementsCompletion');
        const checker = program.getTypeChecker();
        if (checker && typeNode) {
            const type = checker.getTypeFromTypeNode(typeNode.type);
            const el = type.getProperty(tagName);
            if (el) {
                const attrs = checker.getTypeOfSymbolAtLocation(el, typeNode).getProperties();
                return attrs.map(c => c.name);
            }
        }
    }
    return [];
}
function getVariableType(ts, languageService, vueCode, name) {
    const program = languageService.getProgram();
    let tsSourceFile;
    if (tsSourceFile = program.getSourceFile(vueCode.fileName)) {
        const node = searchVariableDeclarationNode(ts, tsSourceFile, name);
        const checker = program.getTypeChecker();
        if (checker && node) {
            return {
                node: node,
                type: checker.getTypeAtLocation(node),
            };
        }
    }
}
function searchVariableDeclarationNode(ts, sourceFile, name) {
    let componentsNode;
    walk(sourceFile);
    return componentsNode;
    function walk(node) {
        if (componentsNode) {
            return;
        }
        else if (ts.isVariableDeclaration(node) && node.name.getText() === name) {
            componentsNode = node;
        }
        else {
            node.forEachChild(walk);
        }
    }
}
function generateCommentMarkdown(parts, jsDocTags) {
    const parsedComment = _symbolDisplayPartsToMarkdown(parts);
    const parsedJsDoc = _jsDocTagInfoToMarkdown(jsDocTags);
    let result = [parsedComment, parsedJsDoc].filter(str => !!str).join('\n\n');
    return result;
}
function _symbolDisplayPartsToMarkdown(parts) {
    return parts.map(part => {
        switch (part.kind) {
            case 'keyword':
                return `\`${part.text}\``;
            case 'functionName':
                return `**${part.text}**`;
            default:
                return part.text;
        }
    }).join('');
}
function _jsDocTagInfoToMarkdown(jsDocTags) {
    return jsDocTags.map(tag => {
        const tagName = `*@${tag.name}*`;
        const tagText = tag.text?.map(t => {
            if (t.kind === 'parameterName') {
                return `\`${t.text}\``;
            }
            else {
                return t.text;
            }
        }).join('') || '';
        return `${tagName} ${tagText}`;
    }).join('\n\n');
}
//# sourceMappingURL=componentInfos.js.map