/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ArtifactTab
extends AbstractCBuildPropertyTab {
    public static final String PROPERTY = "org.eclipse.cdt.build.core.buildArtefactType";
    private Label l4;
    private Combo t2;
    private Combo t3;
    private Combo t4;
    private Combo c1;
    private int savedPos = -1;
    private IConfiguration fCfg;
    private IBuildPropertyValue[] values;
    private ITool tTool;
    private boolean canModify = true;
    private Set<String> set2 = new TreeSet<String>();
    private Set<String> set3 = new TreeSet<String>();
    private Set<String> set4 = new TreeSet<String>();

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(this.usercomp, 0);
        l1.setLayoutData((Object)new GridData(1));
        l1.setText(Messages.ArtifactTab_0);
        this.c1 = new Combo(this.usercomp, 2060);
        this.c1.setLayoutData((Object)new GridData(768));
        this.c1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArtifactTab.this.typeChanged();
            }
        });
        this.c1.setOrientation(0x2000000);
        Label l2 = new Label(this.usercomp, 0);
        l2.setLayoutData((Object)new GridData(1));
        l2.setText(Messages.ArtifactTab_1);
        this.t2 = this.setCombo(FIELD.NAME, this.set2);
        this.t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArtifactTab.this.canModify) {
                    String artifactName = ArtifactTab.this.t2.getText();
                    if (!ArtifactTab.this.page.isMultiCfg() && artifactName.trim().length() == 0) {
                        artifactName = ArtifactTab.this.fCfg.getManagedProject().getDefaultArtifactName();
                        ArtifactTab.this.t2.setText(artifactName);
                    }
                    ArtifactTab.this.fCfg.setArtifactName(ArtifactTab.this.t2.getText());
                }
            }
        });
        Label l3 = new Label(this.usercomp, 0);
        l3.setLayoutData((Object)new GridData(1));
        l3.setText(Messages.ArtifactTab_2);
        this.t3 = this.setCombo(FIELD.EXT, this.set3);
        this.t3.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArtifactTab.this.canModify) {
                    ArtifactTab.this.fCfg.setArtifactExtension(ArtifactTab.this.t3.getText());
                }
            }
        });
        this.l4 = new Label(this.usercomp, 0);
        this.l4.setLayoutData((Object)new GridData(1));
        this.l4.setText(Messages.ArtifactTab_3);
        this.t4 = this.setCombo(FIELD.PREF, this.set4);
        this.t4.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArtifactTab.this.canModify) {
                    if (ArtifactTab.this.tTool != null) {
                        ArtifactTab.this.tTool.setOutputPrefixForPrimaryOutput(ArtifactTab.this.t4.getText());
                    } else if (ArtifactTab.this.fCfg instanceof IMultiConfiguration) {
                        ((IMultiConfiguration)ArtifactTab.this.fCfg).setOutputPrefixForPrimaryOutput(ArtifactTab.this.t4.getText());
                    }
                }
            }
        });
        this.updateData(this.getResDesc());
    }

    private void typeChanged() {
        int n = this.c1.getSelectionIndex();
        if (n != this.savedPos) {
            this.setProjectType(n);
            this.savedPos = n;
            this.updateData(this.getResDesc());
        }
    }

    private void setProjectType(int n) {
        try {
            String s = this.values[n].getId();
            this.fCfg.setBuildArtefactType(s);
        }
        catch (BuildException ex) {
            ManagedBuilderUIPlugin.log(ex);
        }
    }

    public void updateData(ICResourceDescription cfgd) {
        String s;
        if (cfgd == null) {
            return;
        }
        this.fCfg = this.getCfg();
        this.values = this.page.isMultiCfg() ? ((IMultiConfiguration)this.fCfg).getSupportedValues(PROPERTY) : this.fCfg.getBuildProperties().getSupportedValues(PROPERTY);
        this.c1.removeAll();
        this.c1.setData((Object)this.values);
        int i = 0;
        while (i < this.values.length) {
            this.c1.add(this.values[i].getName());
            ++i;
        }
        this.c1.setText("");
        IBuildPropertyValue pv = this.fCfg.getBuildArtefactType();
        if (pv != null) {
            s = pv.getId();
            int i2 = 0;
            while (i2 < this.values.length) {
                if (s.equals(this.values[i2].getId())) {
                    this.c1.select(i2);
                    this.savedPos = i2;
                    break;
                }
                ++i2;
            }
        }
        this.updateCombo(this.t2);
        this.updateCombo(this.t3);
        this.updateCombo(this.t4);
        s = this.fCfg.getArtifactName();
        if (!(this.page.isMultiCfg() || s != null && s.trim().length() != 0)) {
            s = this.fCfg.getManagedProject().getDefaultArtifactName();
            this.getCfg().setArtifactName(s);
        }
        this.canModify = false;
        this.t2.setText(s);
        this.t3.setText(this.fCfg.getArtifactExtension());
        if (this.page.isMultiCfg()) {
            if (this.l4 != null) {
                this.l4.setVisible(true);
            }
            if (this.t4 != null) {
                this.t4.setVisible(true);
                this.t4.setText(((IMultiConfiguration)this.fCfg).getToolOutputPrefix());
            }
        } else {
            this.tTool = this.fCfg.calculateTargetTool();
            if (this.tTool != null) {
                if (this.l4 != null) {
                    this.l4.setVisible(true);
                }
                if (this.t4 != null) {
                    this.t4.setVisible(true);
                    this.t4.setText(this.tTool.getOutputPrefix());
                }
            } else {
                if (this.l4 != null) {
                    this.l4.setVisible(false);
                }
                if (this.t4 != null) {
                    this.t4.setVisible(false);
                }
            }
        }
        this.canModify = true;
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        IConfiguration cfg1 = ArtifactTab.getCfg(src.getConfiguration());
        IConfiguration cfg2 = ArtifactTab.getCfg(dst.getConfiguration());
        String artifactName = cfg1.getArtifactName();
        if (!(this.page.isMultiCfg() || artifactName != null && artifactName.trim().length() != 0)) {
            artifactName = cfg1.getManagedProject().getDefaultArtifactName();
        }
        cfg2.setArtifactName(artifactName);
        cfg2.setArtifactExtension(cfg1.getArtifactExtension());
        ITool t1 = cfg1.calculateTargetTool();
        ITool t2 = cfg2.calculateTargetTool();
        if (t1 != null && t2 != null) {
            t2.setOutputPrefixForPrimaryOutput(t1.getOutputPrefix());
        }
        try {
            IBuildPropertyValue bv = cfg1.getBuildArtefactType();
            if (bv != null) {
                cfg2.setBuildArtefactType(bv.getId());
            }
        }
        catch (BuildException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    protected void performDefaults() {
        this.fCfg.setArtifactName(this.fCfg.getManagedProject().getDefaultArtifactName());
        this.fCfg.setArtifactExtension(null);
        if (this.c1.getItemCount() > 1) {
            int right = this.c1.getSelectionIndex();
            int wrong = right == 0 ? 1 : 0;
            this.setProjectType(wrong);
            this.setProjectType(right);
        }
        if (this.tTool != null) {
            this.tTool.setOutputPrefixForPrimaryOutput(null);
        } else if (this.fCfg instanceof IMultiConfiguration) {
            ((IMultiConfiguration)this.fCfg).setOutputPrefixForPrimaryOutput(null);
        }
        this.updateData(this.getResDesc());
    }

    public boolean canBeVisible() {
        if (this.page.isForProject()) {
            if (this.page.isMultiCfg()) {
                ICMultiItemsHolder mih = (ICMultiItemsHolder)this.getCfg();
                IConfiguration[] cfs = (IConfiguration[])mih.getItems();
                int i = 0;
                while (i < cfs.length) {
                    if (cfs[i].getBuilder().isManagedBuildOn()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return this.getCfg().getBuilder().isManagedBuildOn();
        }
        return false;
    }

    protected void updateButtons() {
    }

    private Combo setCombo(FIELD field, Set<String> set) {
        Combo combo = new Combo(this.usercomp, 2048);
        combo.setLayoutData((Object)new GridData(768));
        combo.setData("enum", (Object)field);
        combo.setData("set", set);
        this.updateCombo(combo);
        return combo;
    }

    private void updateCombo(Combo combo) {
        FIELD field = (FIELD)((Object)combo.getData("enum"));
        Set set = (Set)combo.getData("set");
        if (field == null || set == null) {
            return;
        }
        this.canModify = false;
        String oldStr = combo.getText();
        combo.removeAll();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.page.getCfgsEditable();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cf = iCConfigurationDescriptionArray[n2];
            IConfiguration c = ArtifactTab.getCfg(cf);
            String s = null;
            switch (field) {
                case NAME: {
                    s = c.getArtifactName();
                    break;
                }
                case EXT: {
                    s = c.getArtifactExtension();
                    break;
                }
                case PREF: {
                    ITool t = c.calculateTargetTool();
                    if (t == null) break;
                    s = t.getOutputPrefix();
                }
            }
            if (s != null && s.trim().length() > 0) {
                set.add(s.trim());
            }
            ++n2;
        }
        if (set.size() > 0) {
            combo.setItems(set.toArray(new String[set.size()]));
        }
        combo.setText(oldStr);
        this.canModify = true;
    }

    private static enum FIELD {
        NAME,
        EXT,
        PREF;

    }
}

