/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.commons.core.XmlMemento;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.externalization.AbstractExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;

public class TaskActivationExternalizationParticipant
extends AbstractExternalizationParticipant
implements ITaskActivationListener {
    private final ExternalizationManager externalizationManager;
    private boolean dirty;
    private final TaskActivationHistory activationHistory;
    private final File file;
    private final TaskList taskList;

    public TaskActivationExternalizationParticipant(ExternalizationManager externalizationManager, TaskList taskList, TaskActivationHistory history, File file) {
        this.externalizationManager = externalizationManager;
        this.taskList = taskList;
        this.activationHistory = history;
        this.file = file;
    }

    @Override
    public String getDescription() {
        return Messages.TaskActivationExternalizationParticipant_Task_Activation_History;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ITasksCoreConstants.ACTIVITY_SCHEDULING_RULE;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSave() {
        TaskActivationExternalizationParticipant taskActivationExternalizationParticipant = this;
        synchronized (taskActivationExternalizationParticipant) {
            this.dirty = true;
        }
        this.externalizationManager.requestSave();
    }

    @Override
    public void load(File sourceFile, IProgressMonitor monitor) throws CoreException {
        block13: {
            try {
                this.activationHistory.clear();
                if (!this.file.exists()) break block13;
                FileReader reader = new FileReader(this.file);
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    try {
                        XmlMemento[] items;
                        XmlMemento memento = XmlMemento.createReadRoot((Reader)reader);
                        XmlMemento[] xmlMementoArray = items = memento.getChildren("task");
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractTask task;
                            XmlMemento child = xmlMementoArray[n2];
                            String handle = child.getString("handle");
                            if (handle != null && (task = this.taskList.getTask(handle)) != null) {
                                this.activationHistory.addTaskInternal(task);
                            }
                            ++n2;
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to load task activation history", (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(File targetFile, IProgressMonitor monitor) throws CoreException {
        TaskActivationExternalizationParticipant taskActivationExternalizationParticipant = this;
        synchronized (taskActivationExternalizationParticipant) {
            this.dirty = false;
        }
        XmlMemento memento = XmlMemento.createWriteRoot((String)"taskActivationHistory");
        for (AbstractTask task : this.activationHistory.getPreviousTasks()) {
            XmlMemento child = memento.createChild("task");
            child.putString("handle", task.getHandleIdentifier());
        }
        try {
            this.file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.file);
            Object object = null;
            Object var6_8 = null;
            try {
                try {
                    memento.save((Writer)writer);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to save task activation history", (Throwable)e));
        }
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public File getFile(String rootPath) throws CoreException {
        return this.file;
    }

    @Override
    public void preTaskActivated(ITask task) {
    }

    @Override
    public void preTaskDeactivated(ITask task) {
    }

    @Override
    public void taskActivated(ITask task) {
        this.activationHistory.addTask((AbstractTask)task);
        this.requestSave();
    }

    @Override
    public void taskDeactivated(ITask task) {
    }
}

