/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtend.core.macro.declaration.AbstractElementImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class XtendAnnotationReferenceImpl
extends AbstractElementImpl<XAnnotation>
implements AnnotationReference {
    public AnnotationTypeDeclaration getAnnotationTypeDeclaration() {
        JvmType _annotationType;
        AnnotationTypeDeclaration _switchResult = null;
        JvmType type = _annotationType = this.getAnnotationType();
        boolean _matched = false;
        if (type instanceof JvmAnnotationType) {
            _matched = true;
            TypeDeclaration _typeDeclaration = this.getCompilationUnit().toTypeDeclaration((JvmDeclaredType)type);
            _switchResult = (AnnotationTypeDeclaration)_typeDeclaration;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public JvmType getAnnotationType() {
        boolean _eIsProxy;
        Object _eGet;
        boolean _not;
        JvmType _xblockexpression = null;
        boolean _isIndexing = this.getCompilationUnit().isIndexing();
        boolean bl = _not = !_isIndexing;
        if (_not) {
            return ((XAnnotation)this.getDelegate()).getAnnotationType();
        }
        JvmType _switchResult = null;
        Object proxy = _eGet = ((XAnnotation)this.getDelegate()).eGet((EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, false);
        boolean _matched = false;
        if (proxy instanceof EObject && (_eIsProxy = ((EObject)proxy).eIsProxy())) {
            _matched = true;
            URI uri = ((InternalEObject)proxy).eProxyURI();
            EObject _eObject = ((XAnnotation)this.getDelegate()).eResource().getResourceSet().getEObject(uri, true);
            return (JvmType)_eObject;
        }
        if (!_matched && proxy instanceof JvmType) {
            _matched = true;
            _switchResult = (JvmType)proxy;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public Expression getExpression(String property) {
        XExpression value = this.findValue(property);
        if (value != null) {
            return this.getCompilationUnit().toExpression(value);
        }
        return null;
    }

    public Object getValue(String property) {
        XExpression value = this.findValue(property);
        if (value != null) {
            return this.translateAnnotationValue(value, property);
        }
        return this.getAnnotationTypeDeclaration().findDeclaredAnnotationTypeElement(property).getDefaultValue();
    }

    protected XExpression findValue(String property) {
        XExpression _xblockexpression = null;
        if (Objects.equals(property, "value") && ((XAnnotation)this.getDelegate()).getValue() != null) {
            return ((XAnnotation)this.getDelegate()).getValue();
        }
        Functions.Function1 _function = it -> {
            String _simpleName = it.getElement().getSimpleName();
            return Objects.equals(_simpleName, property);
        };
        XAnnotationElementValuePair _findFirst = (XAnnotationElementValuePair)IterableExtensions.findFirst((Iterable)((XAnnotation)this.getDelegate()).getElementValuePairs(), (Functions.Function1)_function);
        XExpression _value = null;
        if (_findFirst != null) {
            _value = _findFirst.getValue();
        }
        _xblockexpression = _value;
        return _xblockexpression;
    }

    protected Object translateAnnotationValue(XExpression value, String property) {
        JvmType annotationType = ((XAnnotation)this.getDelegate()).getAnnotationType();
        if (annotationType instanceof JvmAnnotationType) {
            Functions.Function1 _function = it -> {
                String _simpleName = it.getSimpleName();
                return Objects.equals(_simpleName, property);
            };
            JvmOperation operation = (JvmOperation)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)((JvmAnnotationType)annotationType).getMembers(), JvmOperation.class), (Functions.Function1)_function);
            if (operation != null) {
                boolean array = this.getCompilationUnit().getTypeReferences().isArray(operation.getReturnType());
                return this.getCompilationUnit().translateAnnotationValue(value, operation.getReturnType(), array);
            }
        }
        return this.getCompilationUnit().translateAnnotationValue(value, (JvmTypeReference)null, false);
    }

    public AnnotationReference getAnnotationValue(String name) {
        Object _value = this.getValue(name);
        return (AnnotationReference)_value;
    }

    public AnnotationReference[] getAnnotationArrayValue(String name) {
        Object _value = this.getValue(name);
        return (AnnotationReference[])_value;
    }

    public boolean[] getBooleanArrayValue(String name) {
        Object _value = this.getValue(name);
        return (boolean[])_value;
    }

    public boolean getBooleanValue(String name) {
        Boolean _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return false;
        }
        _xblockexpression = (Boolean)value;
        return _xblockexpression;
    }

    public byte[] getByteArrayValue(String name) {
        Object _value = this.getValue(name);
        return (byte[])_value;
    }

    public byte getByteValue(String name) {
        Byte _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0;
        }
        _xblockexpression = (Byte)value;
        return _xblockexpression;
    }

    public char[] getCharArrayValue(String name) {
        Object _value = this.getValue(name);
        return (char[])_value;
    }

    public char getCharValue(String name) {
        Character _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return '\u0000';
        }
        Character _switchResult = null;
        boolean _matched = false;
        if (value instanceof Byte) {
            _matched = true;
            _switchResult = Character.valueOf((char)((Byte)value).byteValue());
        }
        if (!_matched) {
            _switchResult = (Character)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression.charValue();
    }

    public TypeReference getClassValue(String name) {
        Object _value = this.getValue(name);
        return (TypeReference)_value;
    }

    public TypeReference[] getClassArrayValue(String name) {
        Object _value = this.getValue(name);
        return (TypeReference[])_value;
    }

    public double[] getDoubleArrayValue(String name) {
        Object _value = this.getValue(name);
        return (double[])_value;
    }

    public double getDoubleValue(String name) {
        Double _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0.0;
        }
        Double _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = ((Character)value).charValue();
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = (double)((Byte)value);
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = (double)((Short)value);
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _switchResult = (double)((Integer)value);
        }
        if (!_matched && value instanceof Long) {
            _matched = true;
            _switchResult = (double)((Long)value);
        }
        if (!_matched && value instanceof Float) {
            _matched = true;
            _switchResult = ((Float)value).floatValue();
        }
        if (!_matched) {
            _switchResult = (Double)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public EnumerationValueDeclaration getEnumValue(String name) {
        Object _value = this.getValue(name);
        return (EnumerationValueDeclaration)_value;
    }

    public EnumerationValueDeclaration[] getEnumArrayValue(String name) {
        Object _value = this.getValue(name);
        return (EnumerationValueDeclaration[])_value;
    }

    public float[] getFloatArrayValue(String name) {
        Object _value = this.getValue(name);
        return (float[])_value;
    }

    public float getFloatValue(String name) {
        Float _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0.0f;
        }
        Float _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = Float.valueOf(((Character)value).charValue());
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = Float.valueOf(((Byte)value).byteValue());
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = Float.valueOf(((Short)value).shortValue());
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _switchResult = Float.valueOf(((Integer)value).intValue());
        }
        if (!_matched && value instanceof Long) {
            _matched = true;
            _switchResult = Float.valueOf(((Long)value).longValue());
        }
        if (!_matched) {
            _switchResult = (Float)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression.floatValue();
    }

    public int[] getIntArrayValue(String name) {
        Object _value = this.getValue(name);
        return (int[])_value;
    }

    public int getIntValue(String name) {
        Integer _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0;
        }
        Integer _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = ((Character)value).charValue();
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = (int)((Byte)value);
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = (int)((Short)value);
        }
        if (!_matched) {
            _switchResult = (Integer)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public long[] getLongArrayValue(String name) {
        Object _value = this.getValue(name);
        return (long[])_value;
    }

    public long getLongValue(String name) {
        Long _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0L;
        }
        Long _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = ((Character)value).charValue();
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = (long)((Byte)value);
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = (long)((Short)value);
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _switchResult = (long)((Integer)value);
        }
        if (!_matched) {
            _switchResult = (Long)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public short[] getShortArrayValue(String name) {
        Object _value = this.getValue(name);
        return (short[])_value;
    }

    public short getShortValue(String name) {
        Short _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0;
        }
        Short _switchResult = null;
        boolean _matched = false;
        if (value instanceof Byte) {
            _matched = true;
            _switchResult = (short)((Byte)value);
        }
        if (!_matched) {
            _switchResult = (Short)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String[] getStringArrayValue(String name) {
        Object _value = this.getValue(name);
        return (String[])_value;
    }

    public String getStringValue(String name) {
        Object _value = this.getValue(name);
        return (String)_value;
    }
}

