/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransfer;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferData;
import org.eclipse.cdt.make.internal.ui.dnd.TextTransferDragSourceListener;
import org.eclipse.cdt.make.ui.views.PasteTargetAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class CopyTargetAction
extends SelectionListenerAction {
    private final Shell shell;
    private final Clipboard clipboard;
    private final PasteTargetAction pasteAction;

    public CopyTargetAction(Shell shell, Clipboard clipboard, PasteTargetAction pasteAction) {
        super(MakeUIPlugin.getResourceString("CopyTargetAction.label"));
        this.shell = shell;
        this.clipboard = clipboard;
        this.pasteAction = pasteAction;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.setToolTipText(MakeUIPlugin.getResourceString("CopyTargetAction.tooltip"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        return MakeTargetDndUtil.isDragable((ISelection)selection);
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        MakeTargetTransferData makeTargetTransferData = new MakeTargetTransferData();
        for (Object selectionItem : selection.toList()) {
            if (!(selectionItem instanceof IMakeTarget)) continue;
            makeTargetTransferData.addMakeTarget((IMakeTarget)selectionItem);
        }
        try {
            this.clipboard.setContents(new Object[]{makeTargetTransferData, TextTransferDragSourceListener.convertSelectedMakeTargetsToText(selection)}, new Transfer[]{MakeTargetTransfer.getInstance(), TextTransfer.getInstance()});
            if (this.pasteAction != null && this.pasteAction.getStructuredSelection() != null) {
                this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
            }
        }
        catch (SWTError e) {
            MakeUIPlugin.errorDialog(this.shell, MakeUIPlugin.getResourceString("CopyTargetAction.title.clipboardProblem"), MakeUIPlugin.getResourceString("CopyTargetAction.message.clipboardProblem"), e);
        }
    }
}

