/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.CompoundContributionItem;

abstract class AbstractWorkingSetConfigsContribution
extends CompoundContributionItem {
    private IWorkingSetProxy workingSet;
    private Comparator<IWorkingSetConfiguration> configOrdering = new Comparator<IWorkingSetConfiguration>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(IWorkingSetConfiguration o1, IWorkingSetConfiguration o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    };

    public AbstractWorkingSetConfigsContribution() {
    }

    AbstractWorkingSetConfigsContribution(IWorkingSetProxy workingSet) {
        this.workingSet = workingSet;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.getWorkingSet() == null) {
            return new IContributionItem[0];
        }
        ArrayList<IWorkingSetConfiguration> configs = new ArrayList<IWorkingSetConfiguration>(this.getWorkingSet().getConfigurations());
        Collections.sort(configs, this.configOrdering);
        IContributionItem[] result = new IContributionItem[configs.size()];
        int i = 0;
        for (IWorkingSetConfiguration next : configs) {
            result[i] = this.createContribution(next, i);
            ++i;
        }
        return result;
    }

    protected abstract IContributionItem createContribution(IWorkingSetConfiguration var1, int var2);

    protected IWorkingSetProxy getWorkingSet() {
        Object first;
        IStructuredSelection ssel;
        ISelection sel;
        if (this.workingSet == null && (sel = CUIPlugin.getActivePage().getSelection()) instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty() && (first = ssel.getFirstElement()) instanceof IWorkingSet) {
            this.workingSet = WorkingSetConfigurationManager.getDefault().getWorkingSet(((IWorkingSet)first).getName());
        }
        return this.workingSet;
    }
}

