/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.disassembly;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextListener;
import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextService;
import org.eclipse.core.runtime.ListenerList;

public class DisassemblyContextService
implements IDisassemblyContextService {
    private ListenerList<IDisassemblyContextListener> fListeners;
    private Set<Object> fContexts = new CopyOnWriteArraySet<Object>();

    public DisassemblyContextService() {
        this.fListeners = new ListenerList();
    }

    @Override
    public void addDisassemblyContextListener(IDisassemblyContextListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeDisassemblyContextListener(IDisassemblyContextListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void register(Object context) {
        this.fContexts.add(context);
        for (IDisassemblyContextListener listener : this.fListeners) {
            listener.contextAdded(context);
        }
    }

    @Override
    public void unregister(Object context) {
        this.fContexts.remove(context);
        for (IDisassemblyContextListener listener : this.fListeners) {
            listener.contextRemoved(context);
        }
    }

    public void dispose() {
        for (Object context : this.fContexts) {
            for (IDisassemblyContextListener listener : this.fListeners) {
                listener.contextRemoved(context);
            }
        }
        this.fListeners.clear();
        this.fContexts.clear();
    }
}

