/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewContextService
implements IDebugContextListener,
IPerspectiveListener4,
IEclipsePreferences.IPreferenceChangeListener,
IContextManagerListener {
    private final Map<IPerspectiveDescriptor, String> fPerspectiveToActiveContext = new HashMap<IPerspectiveDescriptor, String>();
    private final Map<IPerspectiveDescriptor, Set<String>> fPerspectiveToActivatedContexts = new HashMap<IPerspectiveDescriptor, Set<String>>();
    private Map<String, DebugContextViewBindings> fContextIdsToBindings;
    private Set<String> fEnabledPerspectives = new HashSet<String>();
    private boolean fIgnoreChanges = false;
    private IWorkbenchWindow fWindow;
    private final IContextService fContextService;
    private final IDebugContextService fDebugContextService;
    private IPerspectiveDescriptor fActivePerspective;
    public static final String DEBUG_CONTEXT = "org.eclipse.debug.ui.debugging";
    private static final String ID_CONTEXT_VIEW_BINDINGS = "contextViewBindings";
    private static final String ELEM_CONTEXT_VIEW_BINDING = "contextViewBinding";
    private static final String ELEM_PERSPECTIVE = "perspective";
    private static final String ATTR_CONTEXT_ID = "contextId";
    private static final String ATTR_VIEW_ID = "viewId";
    private static final String ATTR_AUTO_OPEN = "autoOpen";
    private static final String ATTR_AUTO_CLOSE = "autoClose";
    private static final String ATTR_PERSPECTIVE_ID = "perspectiveId";
    private static final String XML_ELEMENT_VIEW_BINDINGS = "viewBindings";
    private static final String XML_ELEMENT_PERSPECTIVE = "perspective";
    private static final String XML_ELEMENT_VIEW = "view";
    private static final String XML_ATTR_ID = "id";
    private static final String XML_ATTR_USER_ACTION = "userAction";
    private static final String XML_VALUE_OPENED = "opened";
    private static final String XML_VALUE_CLOSED = "closed";
    private static Set<String> fgBaseDebugViewIds = null;
    private static String[] EMPTY_IDS;

    static {
        fgBaseDebugViewIds = new HashSet<String>();
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.DebugView");
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.VariableView");
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.BreakpointView");
        fgBaseDebugViewIds.add("org.eclipse.ui.console.ConsoleView");
        EMPTY_IDS = new String[0];
    }

    private IDebugContextService getDebugContextService() {
        return this.fDebugContextService;
    }

    ViewContextService(IWorkbenchWindow window) {
        IWorkbenchPage page;
        this.fWindow = window;
        this.fContextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
        this.fDebugContextService = DebugUITools.getDebugContextManager().getContextService(this.fWindow);
        this.loadContextToViewExtensions();
        this.applyUserViewBindings();
        this.loadPerspectives();
        window.addPerspectiveListener((IPerspectiveListener)this);
        this.getDebugContextService().addDebugContextListener(this);
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (node != null) {
            node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.fContextService.addContextManagerListener((IContextManagerListener)this);
        if (this.fWindow != null && (page = this.fWindow.getActivePage()) != null) {
            this.fActivePerspective = page.getPerspective();
        }
    }

    public void dispose() {
        this.fWindow.removePerspectiveListener((IPerspectiveListener)this);
        this.fWindow = null;
        this.getDebugContextService().removeDebugContextListener(this);
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (node != null) {
            node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        this.fContextService.removeContextManagerListener((IContextManagerListener)this);
        this.fActivePerspective = null;
    }

    private void loadContextToViewExtensions() {
        this.fContextIdsToBindings = new HashMap<String, DebugContextViewBindings>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_CONTEXT_VIEW_BINDINGS);
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEM_CONTEXT_VIEW_BINDING.equals(element.getName())) {
                String viewId = element.getAttribute(ATTR_VIEW_ID);
                String contextId = element.getAttribute(ATTR_CONTEXT_ID);
                if (contextId != null && viewId != null) {
                    ViewBinding info = new ViewBinding(element);
                    DebugContextViewBindings bindings = this.fContextIdsToBindings.get(contextId);
                    if (bindings == null) {
                        bindings = new DebugContextViewBindings(contextId);
                        this.fContextIdsToBindings.put(contextId, bindings);
                    }
                    bindings.addBinding(info);
                }
            }
            ++n2;
        }
        this.linkParentContexts();
    }

    private void applyUserViewBindings() {
        String xml = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.user_view_bindings");
        if (xml.length() > 0) {
            try {
                Element root = DebugPlugin.parseDocument((String)xml);
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element entry;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(XML_ELEMENT_VIEW)) {
                        String id = entry.getAttribute(XML_ATTR_ID);
                        for (DebugContextViewBindings binding : this.fContextIdsToBindings.values()) {
                            binding.applyUserSettings(id, entry);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void loadPerspectives() {
        String preference = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.manage_view_perspectives");
        this.fEnabledPerspectives = "DEFAULT".equals(preference) ? ViewContextService.getDefaultEnabledPerspectives() : ViewContextService.parseList(preference);
    }

    private boolean isEnabledPerspective() {
        IPerspectiveDescriptor perspective = this.getActivePerspective();
        if (perspective != null) {
            return this.fEnabledPerspectives.contains(perspective.getId());
        }
        return false;
    }

    private IPerspectiveDescriptor getActivePerspective() {
        if (this.fWindow == null) {
            return null;
        }
        return this.fActivePerspective;
    }

    public static Set<String> parseList(String listString) {
        HashSet<String> list = new HashSet<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    public static Set<String> getDefaultEnabledPerspectives() {
        HashSet<String> perspectives = new HashSet<String>(4);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_CONTEXT_VIEW_BINDINGS);
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String perspectiveId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("perspective".equals(element.getName()) && (perspectiveId = element.getAttribute(ATTR_PERSPECTIVE_ID)) != null) {
                perspectives.add(perspectiveId);
            }
            ++n2;
        }
        return perspectives;
    }

    public void contextActivated(ISelection selection) {
        if (this.isEnabledPerspective() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (!selection.isEmpty()) {
                for (Object target : ss) {
                    ILaunchConfiguration launchConfiguration;
                    ILaunch launch = DebugModelContextBindingManager.getLaunch(target);
                    if (launch == null || launch.isTerminated() || (launchConfiguration = launch.getLaunchConfiguration()) == null) continue;
                    try {
                        List<String> workbenchContexts;
                        ILaunchConfigurationType type = launchConfiguration.getType();
                        if (!this.fContextService.getActiveContextIds().contains(type.getIdentifier() + ".internal." + this.getActivePerspective().getId()) || (workbenchContexts = DebugModelContextBindingManager.getDefault().getWorkbenchContextsForDebugContext(target)).isEmpty()) continue;
                        boolean needToActivate = false;
                        for (String workbenchContext : workbenchContexts) {
                            if (this.isActivated(workbenchContext)) continue;
                            needToActivate = true;
                            break;
                        }
                        if (!needToActivate) continue;
                        Set<String> allViewIds = this.getAllContextsViewIDs(workbenchContexts);
                        for (String contextId : workbenchContexts) {
                            if (this.isActivated(contextId)) continue;
                            this.activateChain(contextId, this.getActivePerspective(), allViewIds);
                        }
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                    }
                }
            }
        }
    }

    private boolean isActiveContext(String contextId) {
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null) {
            String activeId = this.fPerspectiveToActiveContext.get(activePerspective);
            return contextId.equals(activeId);
        }
        return false;
    }

    private boolean isActivated(String contextId) {
        Set<String> contexts;
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null && (contexts = this.fPerspectiveToActivatedContexts.get(activePerspective)) != null) {
            return contexts.contains(contextId);
        }
        return false;
    }

    private void addActivated(String contextId) {
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null) {
            Set<String> contexts = this.fPerspectiveToActivatedContexts.get(activePerspective);
            if (contexts == null) {
                contexts = new HashSet<String>();
                this.fPerspectiveToActivatedContexts.put(activePerspective, contexts);
            }
            contexts.add(contextId);
        }
    }

    private void removeActivated(String contextId) {
        Set<String> contexts;
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null && (contexts = this.fPerspectiveToActivatedContexts.get(activePerspective)) != null) {
            contexts.remove(contextId);
        }
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    private void clean(IPerspectiveDescriptor perspective) {
        Set<String> contexts = this.fPerspectiveToActivatedContexts.remove(perspective);
        this.fPerspectiveToActiveContext.remove(perspective);
        if (contexts != null) {
            for (String id : contexts) {
                this.deactivate(id, perspective);
            }
        }
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        Set<String> activatedContexts;
        if (!this.fIgnoreChanges && page.getWorkbenchWindow().equals(this.fWindow) && partRef != null && ("viewShow" == changeId || "viewHide" == changeId) && (activatedContexts = this.fPerspectiveToActivatedContexts.get(perspective)) != null) {
            for (String id : activatedContexts) {
                DebugContextViewBindings bindings = this.fContextIdsToBindings.get(id);
                if (bindings == null) continue;
                bindings.setViewOpened("viewShow" == changeId, partRef.getId());
            }
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page.getWorkbenchWindow().equals(this.fWindow)) {
            this.fActivePerspective = perspective;
            ISelection activeContext = this.getDebugContextService().getActiveContext();
            if (activeContext != null) {
                this.contextActivated(activeContext);
            }
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    private void activateChain(String contextId, IPerspectiveDescriptor perspective, Set<String> allViewIds) {
        DebugContextViewBindings bindings;
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null && (bindings = this.fContextIdsToBindings.get(contextId)) != null) {
            bindings.activateChain(page, perspective, allViewIds);
        }
    }

    private Set<String> getAllContextsViewIDs(List<String> contextIds) {
        if (this.fWindow == null) {
            return Collections.EMPTY_SET;
        }
        TreeSet<String> viewIds = new TreeSet<String>();
        for (String contextId : contextIds) {
            DebugContextViewBindings bindings = this.fContextIdsToBindings.get(contextId);
            if (bindings == null) continue;
            Collections.addAll(viewIds, bindings.getAllViewBindingsIds());
        }
        return viewIds;
    }

    private void linkParentContexts() {
        for (Map.Entry<String, DebugContextViewBindings> entry : this.fContextIdsToBindings.entrySet()) {
            DebugContextViewBindings bindings = entry.getValue();
            if (bindings.getId().equals(DEBUG_CONTEXT)) continue;
            Context context = this.fContextService.getContext(entry.getKey());
            try {
                bindings.setParentId(context.getParentId());
            }
            catch (NotDefinedException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void setActive(IPerspectiveDescriptor perspective, String contextId) {
        if (contextId == null) {
            this.fPerspectiveToActiveContext.remove(perspective);
        } else {
            this.fPerspectiveToActiveContext.put(perspective, contextId);
        }
    }

    public void contextManagerChanged(ContextManagerEvent event) {
        if (event.isActiveContextsChanged() && this.getActivePerspective() != null) {
            Set<String> disabledContexts = this.getDisabledContexts(event);
            if (!disabledContexts.isEmpty()) {
                for (String contextId : disabledContexts) {
                    if (!this.isViewContext(contextId) || !this.isActivated(contextId)) continue;
                    this.deactivate(contextId, this.getActivePerspective());
                }
            }
            this.contextActivated(DebugUITools.getDebugContextManager().getContextService(this.fWindow).getActiveContext());
        }
    }

    private void deactivate(String contextId, IPerspectiveDescriptor perspective) {
        DebugContextViewBindings bindings;
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null && (bindings = this.fContextIdsToBindings.get(contextId)) != null) {
            bindings.deactivate(page, perspective);
        }
    }

    private Set<String> getDisabledContexts(ContextManagerEvent event) {
        HashSet<String> prev = new HashSet<String>(event.getPreviouslyActiveContextIds());
        Set activeContextIds = event.getContextManager().getActiveContextIds();
        if (activeContextIds != null) {
            prev.removeAll(activeContextIds);
        }
        return prev;
    }

    private boolean isViewContext(String id) {
        return this.fContextIdsToBindings.containsKey(id);
    }

    private void saveViewBindings() {
        try {
            try {
                Document document = DebugPlugin.newDocument();
                Element root = document.createElement(XML_ELEMENT_VIEW_BINDINGS);
                document.appendChild(root);
                HashSet<String> done = new HashSet<String>();
                for (DebugContextViewBindings binding : this.fContextIdsToBindings.values()) {
                    binding.saveBindings(document, root, done);
                }
                String prefValue = "";
                if (root.hasChildNodes()) {
                    prefValue = DebugPlugin.serializeDocument((Document)document);
                }
                this.fIgnoreChanges = true;
                DebugUITools.getPreferenceStore().setValue("org.eclipse.debug.ui.user_view_bindings", prefValue);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                this.fIgnoreChanges = false;
            }
        }
        finally {
            this.fIgnoreChanges = false;
        }
    }

    public String[] getEnabledPerspectives() {
        return this.fEnabledPerspectives.toArray(new String[this.fEnabledPerspectives.size()]);
    }

    public void showViewQuiet(String viewId) {
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null) {
            try {
                try {
                    this.fIgnoreChanges = true;
                    IViewPart part = page.showView(viewId, null, 2);
                    if (!page.isPartVisible((IWorkbenchPart)part)) {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
                catch (PartInitException e) {
                    DebugUIPlugin.log(e);
                    this.fIgnoreChanges = false;
                }
            }
            finally {
                this.fIgnoreChanges = false;
            }
        }
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page.getWorkbenchWindow().equals(this.fWindow)) {
            this.fActivePerspective = null;
            this.clean(perspective);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (!this.fIgnoreChanges) {
            if ("org.eclipse.debug.ui.manage_view_perspectives".equals(event.getKey())) {
                this.loadPerspectives();
            } else if ("org.eclipse.debug.ui.user_view_bindings".equals(event.getKey())) {
                this.loadContextToViewExtensions();
                this.applyUserViewBindings();
                this.fPerspectiveToActivatedContexts.clear();
                ISelection selection = this.getDebugContextService().getActiveContext();
                this.contextActivated(selection);
            }
        }
    }

    private class DebugContextViewBindings {
        private final String fId;
        private String[] fViewBindingIds = EMPTY_IDS;
        private String[] fAllViewBindingIds = null;
        private final Map<String, ViewBinding> fAllViewIdToBindings = new HashMap<String, ViewBinding>();
        private String[] fAllConetxtIds = null;
        private String fParentId;

        public DebugContextViewBindings(String id) {
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public void addBinding(ViewBinding binding) {
            String[] newBindings = new String[this.fViewBindingIds.length + 1];
            System.arraycopy(this.fViewBindingIds, 0, newBindings, 0, this.fViewBindingIds.length);
            newBindings[this.fViewBindingIds.length] = binding.getViewId();
            this.fAllViewIdToBindings.put(binding.getViewId(), binding);
            this.fViewBindingIds = newBindings;
        }

        protected void setParentId(String id) {
            this.fParentId = id;
        }

        public DebugContextViewBindings getParentContext() {
            if (this.fParentId == null) {
                return null;
            }
            return ViewContextService.this.fContextIdsToBindings.get(this.fParentId);
        }

        public void activateChain(IWorkbenchPage page, IPerspectiveDescriptor perspective, Set<String> allViewIds) {
            this.initializeChain();
            this.doActivation(page, perspective, allViewIds, this.fAllConetxtIds);
        }

        public String[] getAllViewBindingsIds() {
            this.initializeChain();
            return this.fAllViewBindingIds;
        }

        private void doActivation(IWorkbenchPage page, IPerspectiveDescriptor perspective, Set<String> allViewIds, String[] contextIds) {
            String[] stringArray = contextIds;
            int n = contextIds.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                ViewContextService.this.addActivated(contextId);
                ++n2;
            }
            ViewContextService.this.setActive(perspective, this.getId());
            stringArray = this.fAllViewBindingIds;
            n = this.fAllViewBindingIds.length;
            n2 = 0;
            while (n2 < n) {
                String viewId = stringArray[n2];
                ViewBinding binding = this.fAllViewIdToBindings.get(viewId);
                binding.activated(page, perspective);
                binding.checkZOrder(page, allViewIds);
                ++n2;
            }
        }

        private synchronized void initializeChain() {
            if (this.fAllViewBindingIds == null) {
                ArrayList<String> orderedIds = new ArrayList<String>();
                ArrayList<DebugContextViewBindings> contexts = new ArrayList<DebugContextViewBindings>();
                DebugContextViewBindings context = this;
                while (context != null) {
                    contexts.add(0, context);
                    context = context.getParentContext();
                }
                this.fAllConetxtIds = new String[contexts.size()];
                int pos = 0;
                for (DebugContextViewBindings bindings : contexts) {
                    this.fAllConetxtIds[pos] = bindings.getId();
                    ++pos;
                    String[] stringArray = bindings.fViewBindingIds;
                    int n = bindings.fViewBindingIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String viewId = stringArray[n2];
                        if (bindings == this) {
                            orderedIds.add(viewId);
                        }
                        if (!this.fAllViewIdToBindings.containsKey(viewId)) {
                            orderedIds.add(viewId);
                            this.fAllViewIdToBindings.put(viewId, bindings.fAllViewIdToBindings.get(viewId));
                        }
                        ++n2;
                    }
                }
                this.fAllViewBindingIds = orderedIds.toArray(new String[orderedIds.size()]);
            }
        }

        public void deactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            ViewContextService.this.removeActivated(this.getId());
            if (ViewContextService.this.isActiveContext(this.getId())) {
                ViewContextService.this.setActive(page.getPerspective(), null);
            }
            String[] stringArray = this.fViewBindingIds;
            int n = this.fViewBindingIds.length;
            int n2 = 0;
            while (n2 < n) {
                String viewId = stringArray[n2];
                ViewBinding binding = this.fAllViewIdToBindings.get(viewId);
                binding.deactivated(page, perspective);
                ++n2;
            }
        }

        public void setViewOpened(boolean opened, String viewId) {
            this.initializeChain();
            ViewBinding binding = this.fAllViewIdToBindings.get(viewId);
            if (binding != null) {
                if (opened) {
                    binding.userOpened();
                } else {
                    binding.userClosed();
                }
            }
        }

        public void applyUserSettings(String viewId, Element viewElement) {
            this.initializeChain();
            ViewBinding binding = this.fAllViewIdToBindings.get(viewId);
            if (binding != null) {
                binding.applyUserSettings(viewElement);
            }
        }

        public void saveBindings(Document document, Element root, Set<String> alreadyDone) {
            String[] stringArray = this.fViewBindingIds;
            int n = this.fViewBindingIds.length;
            int n2 = 0;
            while (n2 < n) {
                String viewId = stringArray[n2];
                if (!alreadyDone.contains(viewId)) {
                    alreadyDone.add(viewId);
                    ViewBinding binding = this.fAllViewIdToBindings.get(viewId);
                    binding.saveBindings(document, root);
                }
                ++n2;
            }
        }
    }

    private class ViewBinding {
        private final IConfigurationElement fElement;
        private final Set<String> fUserOpened = new HashSet<String>();
        private final Set<String> fUserClosed = new HashSet<String>();
        private final Set<String> fAutoOpened = new HashSet<String>();

        public ViewBinding(IConfigurationElement element) {
            this.fElement = element;
        }

        public String getViewId() {
            return this.fElement.getAttribute(ViewContextService.ATTR_VIEW_ID);
        }

        public boolean isAutoOpen() {
            String autoopen = this.fElement.getAttribute(ViewContextService.ATTR_AUTO_OPEN);
            return autoopen == null || "true".equals(autoopen);
        }

        public boolean isAutoClose() {
            String autoclose = this.fElement.getAttribute(ViewContextService.ATTR_AUTO_CLOSE);
            return autoclose == null || "true".equals(autoclose);
        }

        public boolean isUserOpened(IPerspectiveDescriptor perspective) {
            return this.fUserOpened.contains(perspective.getId());
        }

        public boolean isUserClosed(IPerspectiveDescriptor perspective) {
            return this.fUserClosed.contains(ViewContextService.this.getActivePerspective().getId());
        }

        public boolean isDefault(IPerspectiveDescriptor perspective) {
            String id = perspective.getId();
            if ("org.eclipse.debug.ui.DebugPerspective".equals(id)) {
                return fgBaseDebugViewIds.contains(this.getViewId());
            }
            return false;
        }

        protected void userOpened() {
            if (this.isTrackingViews()) {
                String id = ViewContextService.this.getActivePerspective().getId();
                this.fAutoOpened.remove(id);
                this.fUserOpened.add(id);
                this.fUserClosed.remove(id);
                ViewContextService.this.saveViewBindings();
            }
        }

        protected void userClosed() {
            if (this.isTrackingViews()) {
                String id = ViewContextService.this.getActivePerspective().getId();
                this.fAutoOpened.remove(id);
                this.fUserClosed.add(id);
                this.fUserOpened.remove(id);
                ViewContextService.this.saveViewBindings();
            }
        }

        protected boolean isTrackingViews() {
            return DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.track_views");
        }

        public void activated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (!this.isUserClosed(perspective) && this.isAutoOpen()) {
                try {
                    try {
                        ViewContextService.this.fIgnoreChanges = true;
                        if (page.findViewReference(this.getViewId()) == null) {
                            this.fAutoOpened.add(perspective.getId());
                        }
                        page.showView(this.getViewId(), null, 3);
                    }
                    catch (PartInitException e) {
                        DebugUIPlugin.log(e);
                        ViewContextService.this.fIgnoreChanges = false;
                    }
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void checkZOrder(IWorkbenchPage page, Set<String> relevantViews) {
            IViewPart[] viewStack;
            String viewId = this.getViewId();
            IViewPart part = page.findView(viewId);
            if (part != null && (viewStack = page.getViewStack(part)) != null && viewStack.length > 0) {
                String top = viewStack[0].getSite().getId();
                if (relevantViews.contains(top)) {
                    return;
                }
                IViewReference partRef = page.findViewReference(viewId);
                if (partRef != null && (partRef.isFastView() || page.getPartState((IWorkbenchPartReference)partRef) == 0)) {
                    return;
                }
                try {
                    ViewContextService.this.fIgnoreChanges = true;
                    page.bringToTop((IWorkbenchPart)part);
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void deactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            IViewReference reference;
            if (!this.isUserOpened(perspective) && this.fAutoOpened.remove(perspective.getId()) && this.isAutoClose() && !this.isDefault(perspective) && (reference = page.findViewReference(this.getViewId())) != null) {
                try {
                    ViewContextService.this.fIgnoreChanges = true;
                    page.hideView(reference);
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void saveBindings(Document document, Element root) {
            Element viewElement = document.createElement(ViewContextService.XML_ELEMENT_VIEW);
            viewElement.setAttribute(ViewContextService.XML_ATTR_ID, this.getViewId());
            this.appendPerspectives(document, viewElement, this.fUserOpened, ViewContextService.XML_VALUE_OPENED);
            this.appendPerspectives(document, viewElement, this.fUserClosed, ViewContextService.XML_VALUE_CLOSED);
            if (viewElement.hasChildNodes()) {
                root.appendChild(viewElement);
            }
        }

        private void appendPerspectives(Document document, Element parent, Set<String> perpectives, String xmlValue) {
            String[] stringArray = perpectives.toArray(new String[perpectives.size()]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Element element = document.createElement("perspective");
                element.setAttribute(ViewContextService.XML_ATTR_ID, id);
                element.setAttribute(ViewContextService.XML_ATTR_USER_ACTION, xmlValue);
                parent.appendChild(element);
                ++n2;
            }
        }

        public void applyUserSettings(Element viewElement) {
            NodeList list = viewElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("perspective")) {
                    String id = entry.getAttribute(ViewContextService.XML_ATTR_ID);
                    String setting = entry.getAttribute(ViewContextService.XML_ATTR_USER_ACTION);
                    if (id != null) {
                        if (ViewContextService.XML_VALUE_CLOSED.equals(setting)) {
                            this.fUserClosed.add(id);
                        } else if (ViewContextService.XML_VALUE_OPENED.equals(setting)) {
                            this.fUserOpened.add(id);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

