/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.generator.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.builder.ITypeScriptSourceBuilder;
import org.eclipse.scout.sdk.core.typescript.builder.nodeelement.INodeElementBuilder;
import org.eclipse.scout.sdk.core.typescript.builder.nodeelement.NodeElementBuilder;
import org.eclipse.scout.sdk.core.typescript.generator.ITypeScriptElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.AbstractNodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.INodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.SortedNodeElementEntry;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.util.Ensure;

public class TypeGenerator<TYPE extends ITypeGenerator<TYPE>>
extends AbstractNodeElementGenerator<TYPE>
implements ITypeGenerator<TYPE> {
    private boolean m_asClass;
    private boolean m_asInterface;
    private IES6Class m_superClass;
    private final List<SortedNodeElementEntry> m_nodeElements = new ArrayList<SortedNodeElementEntry>();

    protected TypeGenerator() {
    }

    public static ITypeGenerator<?> create() {
        return new TypeGenerator();
    }

    @Override
    protected void build(ITypeScriptSourceBuilder<?> builder) {
        super.build(builder);
        this.buildType(builder);
    }

    protected void buildType(ITypeScriptSourceBuilder<?> builder) {
        this.buildTypeDeclaration(NodeElementBuilder.create(builder));
        builder.blockStart().nl();
        this.buildTypeBody(builder);
        ((ITypeScriptSourceBuilder)builder.nl()).blockEnd();
    }

    protected void buildTypeDeclaration(INodeElementBuilder<?> builder) {
        if (!this.m_asClass && !this.m_asInterface) {
            return;
        }
        builder.appendModifiers(this.modifiers());
        if (this.m_asClass) {
            builder.append("class ");
        } else {
            builder.append("interface ");
        }
        builder.append(this.elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"Type must have a name.", (Object[])new Object[0])));
        if (this.m_asClass) {
            this.superClass().ifPresent(superClass -> ((INodeElementBuilder)builder.append(" extends ")).ref((IDataType)superClass));
        }
        builder.space();
    }

    protected void buildTypeBody(ITypeScriptSourceBuilder<?> builder) {
        builder.append(this.m_nodeElements.stream().sorted().map(SortedNodeElementEntry::generator), null, builder.context().lineDelimiter(), null);
    }

    @Override
    public TYPE asClass() {
        this.m_asClass = true;
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE asInterface() {
        this.m_asInterface = true;
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public Optional<IES6Class> superClass() {
        return Optional.ofNullable(this.m_superClass);
    }

    @Override
    public TYPE withSuperClass(IES6Class superClass) {
        this.m_superClass = superClass;
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public Stream<IFieldGenerator<?>> fields() {
        return this.m_nodeElements.stream().filter(SortedNodeElementEntry::isField).map(SortedNodeElementEntry::generator).map(g -> (IFieldGenerator)g);
    }

    @Override
    public TYPE withField(IFieldGenerator<?> generator, Object ... sortObject) {
        this.m_nodeElements.add(new SortedNodeElementEntry(TypeGenerator.applyConnection(generator, this), sortObject));
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutField(Predicate<IFieldGenerator<?>> removalFilter) {
        this.removeNodeElementIf(IFieldGenerator.class, removalFilter);
        return (TYPE)((ITypeGenerator)this.thisInstance());
    }

    protected <T extends INodeElementGenerator<?>, P extends INodeElementGenerator<?>> void removeNodeElementIf(Class<T> type, Predicate<P> removalFilter) {
        Iterator<SortedNodeElementEntry> it = this.m_nodeElements.iterator();
        while (it.hasNext()) {
            SortedNodeElementEntry entry = it.next();
            if (!entry.hasType(type)) continue;
            INodeElementGenerator<?> generator = entry.generator();
            if (removalFilter != null && !removalFilter.test(generator)) continue;
            it.remove();
            TypeGenerator.applyConnection(generator, null);
        }
    }

    protected static <T extends INodeElementGenerator<?>> T applyConnection(T child, ITypeScriptElementGenerator<?> parent) {
        if (child instanceof AbstractNodeElementGenerator) {
            ((AbstractNodeElementGenerator)child).withDeclaringGenerator(parent);
        }
        return child;
    }
}

