/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;

public final class CheckUselessBlocks
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    public static final DiagnosticType USELESS_BLOCK = DiagnosticType.warning("JSC_USELESS_BLOCK", "Useless block.");
    private final AbstractCompiler compiler;
    private Deque<Node> loneBlocks;

    public CheckUselessBlocks(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.loneBlocks = new ArrayDeque<Node>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    private boolean isLoneBlock(Node n) {
        Node parent = n.getParent();
        if (parent != null && (parent.isScript() || parent.isBlock() && !parent.isSyntheticBlock() && !parent.isAddedBlock())) {
            return n.isBlock() && !n.isSyntheticBlock() && !n.isAddedBlock();
        }
        return false;
    }

    private void allowLoneBlock(Node parent) {
        if (this.loneBlocks.isEmpty()) {
            return;
        }
        if (this.loneBlocks.peek() == parent) {
            this.loneBlocks.pop();
        }
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 125: {
                if (!this.isLoneBlock(n)) break;
                this.loneBlocks.push(n);
                break;
            }
            case 149: 
            case 162: {
                this.allowLoneBlock(parent);
                break;
            }
            case 158: {
                if (!NodeUtil.isClassDeclaration(n)) break;
                this.allowLoneBlock(parent);
                break;
            }
            case 105: {
                if (!NodeUtil.isFunctionDeclaration(n)) break;
                this.allowLoneBlock(parent);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isBlock() && !this.loneBlocks.isEmpty() && this.loneBlocks.peek() == n) {
            this.loneBlocks.pop();
            t.report(n, USELESS_BLOCK, new String[0]);
        }
    }
}

