/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public class QuickFixRenameMember
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return QuickFixMessages.QuickFixRenameMember_rename_member;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        IASTTranslationUnit ast;
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            ast = tu.getAST(index, 2);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        IASTName astName = this.isCodanProblem(marker) ? this.getASTNameFromMarker(marker, ast) : this.getAstNameFromProblemArgument(marker, ast, 1);
        if (astName == null) {
            return;
        }
        ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)ast);
        INodeFactory factory = ast.getASTNodeFactory();
        String[] args = CodanProblemMarker.getProblemArguments((IMarker)marker);
        if (args == null || args.length < 3) {
            return;
        }
        IASTName newName = factory.newName(args[2]);
        r.replace((IASTNode)astName, (IASTNode)newName, null);
        Change c = r.rewriteAST();
        try {
            c.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        try {
            marker.delete();
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }
}

