/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.core.resources.IResource;

public class CatchByReference
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.CatchByReference";
    public static final String PARAM_EXCEPT_ARG_LIST = "exceptions";
    public static final String PARAM_UNKNOWN_TYPE = "unknown";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnCatch());
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_UNKNOWN_TYPE, CheckersMessages.CatchByReference_ReportForUnknownType, Boolean.FALSE);
        this.addListPreference(problem, PARAM_EXCEPT_ARG_LIST, CheckersMessages.GenericParameter_ParameterExceptions, CheckersMessages.GenericParameter_ParameterExceptionsItem);
    }

    public boolean isFilteredArg(String arg) {
        Object[] arr = (Object[])this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_EXCEPT_ARG_LIST);
        int i = 0;
        while (i < arr.length) {
            String str = (String)arr[i];
            if (arg.equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldReportForUnknownType() {
        return (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_UNKNOWN_TYPE);
    }

    class OnCatch
    extends ASTVisitor {
        OnCatch() {
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof ICPPASTTryBlockStatement) {
                try {
                    ICPPASTTryBlockStatement tblock = (ICPPASTTryBlockStatement)stmt;
                    ICPPASTCatchHandler[] catchHandlers = tblock.getCatchHandlers();
                    int i = 0;
                    while (i < catchHandlers.length) {
                        ICPPASTCatchHandler catchHandler = catchHandlers[i];
                        IASTDeclaration decl = catchHandler.getDeclaration();
                        if (decl instanceof IASTSimpleDeclaration) {
                            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
                            IASTDeclSpecifier spec = sdecl.getDeclSpecifier();
                            if (!this.usesReference(catchHandler) && spec instanceof IASTNamedTypeSpecifier) {
                                String arg;
                                IASTName tname = ((IASTNamedTypeSpecifier)spec).getName();
                                IType typeName = (IType)tname.resolveBinding();
                                if (!((typeName = CxxAstUtils.unwindTypedef((IType)typeName)) instanceof IBasicType || typeName instanceof IPointerType || typeName == null || typeName instanceof IProblemBinding && !CatchByReference.this.shouldReportForUnknownType() || CatchByReference.this.isFilteredArg(arg = spec.getRawSignature()))) {
                                    CatchByReference.this.reportProblem(CatchByReference.ER_ID, (IASTNode)decl, new Object[]{arg});
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    CodanCheckersActivator.log(e);
                }
                return 1;
            }
            return 3;
        }

        private boolean usesReference(ICPPASTCatchHandler catchHandler) {
            IASTDeclaration declaration = catchHandler.getDeclaration();
            if (declaration instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] declarators = ((IASTSimpleDeclaration)declaration).getDeclarators();
                int i = 0;
                while (i < declarators.length) {
                    IASTDeclarator d = declarators[i];
                    IASTPointerOperator[] pointerOperators = d.getPointerOperators();
                    int j = 0;
                    while (j < pointerOperators.length) {
                        IASTPointerOperator po = pointerOperators[j];
                        if (po instanceof ICPPASTReferenceOperator) {
                            return true;
                        }
                        if (po instanceof IASTPointer) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

