/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view.actions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestPathUtils;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public abstract class RelaunchSelectedAction
extends Action {
    private ITestingSession testingSession;
    private TreeViewer treeViewer;

    public RelaunchSelectedAction(ITestingSession testingSession, TreeViewer treeViewer) {
        this.testingSession = testingSession;
        this.treeViewer = treeViewer;
    }

    protected abstract String getLaunchMode();

    public void run() {
        if (this.testingSession != null) {
            try {
                ILaunch launch = this.testingSession.getLaunch();
                ILaunchConfigurationWorkingCopy launchConf = launch.getLaunchConfiguration().getWorkingCopy();
                List<String> testsFilterAttr = Arrays.asList(TestPathUtils.packTestPaths(this.getSelectedTestItems()));
                launchConf.setAttribute("org.eclipse.cdt.testsrunner.launch.TESTS_FILTER", testsFilterAttr);
                DebugUITools.launch((ILaunchConfiguration)launchConf, (String)this.getLaunchMode());
                return;
            }
            catch (CoreException e) {
                TestsRunnerPlugin.log(e);
            }
        }
        this.setEnabled(false);
    }

    private ITestItem[] getSelectedTestItems() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        ITestItem[] result = new ITestItem[selection.size()];
        int resultIndex = 0;
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            result[resultIndex] = (ITestItem)it.next();
            ++resultIndex;
        }
        return result;
    }

    public void setTestingSession(ITestingSession testingSession) {
        this.testingSession = testingSession;
    }
}

