/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.ruby.internal.typehierarchy.Messages;

public class RubyTypeHierarchyEngine {
    private static final boolean DEBUG = false;

    public static IType[] locateSuperTypes(IType type, IProgressMonitor monitor) {
        try {
            String[] superTypes = type.getSuperClasses();
            ArrayList<IType> types = new ArrayList<IType>();
            if (superTypes != null) {
                monitor.beginTask(Messages.RubyTypeHierarchyEngine_collectingTypes, superTypes.length);
                IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)type));
                int i = 0;
                while (i < superTypes.length) {
                    TypeNameMatch[] possibleTypes = RubyTypeHierarchyEngine.searchTypesForName(superTypes[i], monitor, scope);
                    int j = 0;
                    while (j < possibleTypes.length) {
                        IType sType = possibleTypes[j].getType();
                        if (sType.exists() && RubyTypeHierarchyEngine.filterTypeFromSelection(sType, type)) {
                            types.add(sType);
                        }
                        ++i;
                    }
                    ++i;
                }
            }
            IType[] iTypeArray = types.toArray(new IType[types.size()]);
            return iTypeArray;
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private static boolean filterTypeFromSelection(IType superType, IType type) {
        return true;
    }

    private static TypeNameMatch[] searchTypesForName(String name, IProgressMonitor monitor, IDLTKSearchScope scope) {
        SearchRequestor reqestor = new SearchRequestor();
        SearchEngine engine = new SearchEngine(null);
        monitor.setTaskName(Messages.RubyTypeHierarchyEngine_searchingTypes);
        try {
            engine.searchAllTypeNames(null, 0, name.toCharArray(), 8, 0, scope, (TypeNameMatchRequestor)reqestor, 3, monitor);
            return reqestor.getResult();
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class SearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private List<TypeNameMatch> fResult = new ArrayList<TypeNameMatch>(5);

        public TypeNameMatch[] getResult() {
            return this.fResult.toArray(new TypeNameMatch[this.fResult.size()]);
        }

        public void cancel() {
            this.fStop = true;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (this.fStop) {
                return;
            }
            this.fResult.add(match);
        }
    }
}

