/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.DeltaProcessingState;
import org.eclipse.dltk.internal.core.DeltaProcessor;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;

public class BuildpathChange {
    public static int NO_DELTA = 0;
    public static int HAS_DELTA = 1;
    public static int HAS_PROJECT_CHANGE = 2;
    public static int HAS_LIBRARY_CHANGE = 4;
    ScriptProject project;
    IBuildpathEntry[] oldRawBuildpath;
    IBuildpathEntry[] oldResolvedBuildpath;

    public BuildpathChange(ScriptProject project, IBuildpathEntry[] oldRawBuildpath, IBuildpathEntry[] oldResolvedBuildpath) {
        this.project = project;
        this.oldRawBuildpath = oldRawBuildpath;
        this.oldResolvedBuildpath = oldResolvedBuildpath;
    }

    private void addBuildpathDeltas(ModelElementDelta delta, IProjectFragment[] roots, int flag) {
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0) {
                try {
                    root.close();
                }
                catch (ModelException modelException) {}
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int buildpathContains(IBuildpathEntry[] list, IBuildpathEntry entry) {
        exclusionPatterns = entry.getExclusionPatterns();
        inclusionPatterns = entry.getInclusionPatterns();
        listLen = list == null ? 0 : list.length;
        i = 0;
        while (i < listLen) {
            block7: {
                block9: {
                    block8: {
                        other = list[i];
                        if (other.getContentKind() != entry.getContentKind() || other.getEntryKind() != entry.getEntryKind() || other.isExported() != entry.isExported() || !other.getPath().equals((Object)entry.getPath())) break block7;
                        otherIncludes = other.getInclusionPatterns();
                        if (inclusionPatterns == otherIncludes) break block8;
                        if (inclusionPatterns == null) break block7;
                        includeLength = inclusionPatterns.length;
                        if (otherIncludes != null && otherIncludes.length == includeLength) {
                            j = 0;
                            while (j < includeLength) {
                                if (inclusionPatterns[j].toString().equals(otherIncludes[j].toString())) {
                                    ++j;
                                } else {
                                    ** GOTO lbl-1000
                                }
                            }
                        }
                        break block7;
lbl-1000:
                        // 2 sources

                        {
                            break block7;
                        }
                    }
                    if (exclusionPatterns == (otherExcludes = other.getExclusionPatterns())) break block9;
                    if (exclusionPatterns == null) break block7;
                    excludeLength = exclusionPatterns.length;
                    if (otherExcludes != null && otherExcludes.length == excludeLength) {
                        j = 0;
                        while (j < excludeLength) {
                            if (exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) {
                                ++j;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    }
                    break block7;
lbl-1000:
                    // 2 sources

                    {
                        break block7;
                    }
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildpathChange)) {
            return false;
        }
        return this.project.equals(((BuildpathChange)obj).project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateDelta(ModelElementDelta delta, boolean addBuildpathChange) {
        int entryKind;
        int index;
        ModelManager manager = ModelManager.getModelManager();
        DeltaProcessingState state = manager.deltaState;
        if (state.findProject(this.project.getElementName()) == null) {
            return NO_DELTA;
        }
        DeltaProcessor deltaProcessor = state.getDeltaProcessor();
        IBuildpathEntry[] newResolvedBuildpath = null;
        int result = NO_DELTA;
        try {
            IBuildpathEntry[] newRawBuildpath;
            ModelManager.PerProjectInfo perProjectInfo = this.project.getPerProjectInfo();
            this.project.resolveBuildpath(perProjectInfo, false, addBuildpathChange);
            ModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
            synchronized (perProjectInfo2) {
                newRawBuildpath = perProjectInfo.rawBuildpath;
                newResolvedBuildpath = perProjectInfo.getResolvedBuildpath();
            }
            if (newResolvedBuildpath == null) {
                ModelManager.PerProjectInfo temporaryInfo = this.project.newTemporaryInfo();
                this.project.resolveBuildpath(temporaryInfo, false, addBuildpathChange);
                newRawBuildpath = temporaryInfo.rawBuildpath;
                newResolvedBuildpath = temporaryInfo.getResolvedBuildpath();
            }
            if (this.oldRawBuildpath != null && !ScriptProject.areBuildpathsEqual(this.oldRawBuildpath, newRawBuildpath)) {
                delta.changed(this.project, 131072);
                result |= HAS_DELTA;
                int i = 0;
                int length = this.oldRawBuildpath.length;
                while (i < length) {
                    IBuildpathEntry entry = this.oldRawBuildpath[i];
                    if (entry.getEntryKind() == 5 && this.buildpathContains(newRawBuildpath, entry) == -1) {
                        manager.containerPut(this.project, entry.getPath(), null);
                    }
                    ++i;
                }
            }
            if (this.oldResolvedBuildpath != null && ScriptProject.areBuildpathsEqual(this.oldResolvedBuildpath, newResolvedBuildpath)) {
                return result;
            }
            this.project.close();
        }
        catch (ModelException e) {
            if (DeltaProcessor.VERBOSE) {
                e.printStackTrace();
            }
            return result;
        }
        if (this.oldResolvedBuildpath == null) {
            return result;
        }
        delta.changed(this.project, 0x200000);
        result |= HAS_DELTA;
        state.addForRefresh(this.project);
        HashMap<IPath, IProjectFragment> removedRoots = null;
        IProjectFragment[] roots = null;
        Map<IScriptProject, IProjectFragment[]> allOldRoots = deltaProcessor.oldRoots;
        if (allOldRoots != null) {
            roots = allOldRoots.get(this.project);
        }
        if (roots != null) {
            removedRoots = new HashMap<IPath, IProjectFragment>();
            int i = 0;
            while (i < roots.length) {
                IProjectFragment root = roots[i];
                removedRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int newLength = newResolvedBuildpath.length;
        int oldLength = this.oldResolvedBuildpath.length;
        int i = 0;
        while (i < oldLength) {
            index = this.buildpathContains(newResolvedBuildpath, this.oldResolvedBuildpath[i]);
            if (index == -1) {
                entryKind = this.oldResolvedBuildpath[i].getEntryKind();
                if (entryKind == 2) {
                    result |= HAS_PROJECT_CHANGE;
                } else {
                    IProjectFragment oldRoot;
                    if (entryKind == 1) {
                        result |= HAS_LIBRARY_CHANGE;
                    }
                    IProjectFragment[] pkgFragmentRoots = null;
                    if (removedRoots != null && (oldRoot = (IProjectFragment)removedRoots.get(this.oldResolvedBuildpath[i].getPath())) != null) {
                        pkgFragmentRoots = new IProjectFragment[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ArrayList<IProjectFragment> accumulatedRoots = new ArrayList<IProjectFragment>();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(this.project.rootID());
                            this.project.computeProjectFragments(this.oldResolvedBuildpath[i], accumulatedRoots, rootIDs, null, false, false, null);
                            pkgFragmentRoots = accumulatedRoots.toArray(new IProjectFragment[accumulatedRoots.size()]);
                        }
                        catch (ModelException modelException) {
                            pkgFragmentRoots = new IProjectFragment[]{};
                        }
                    }
                    this.addBuildpathDeltas(delta, pkgFragmentRoots, 128);
                }
            } else if (this.oldResolvedBuildpath[i].getEntryKind() == 2) {
                result |= HAS_PROJECT_CHANGE;
            } else if (index != i) {
                this.addBuildpathDeltas(delta, this.project.computeProjectFragments(this.oldResolvedBuildpath[i]), 256);
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            index = this.buildpathContains(this.oldResolvedBuildpath, newResolvedBuildpath[i]);
            if (index == -1) {
                entryKind = newResolvedBuildpath[i].getEntryKind();
                if (entryKind == 2) {
                    result |= HAS_PROJECT_CHANGE;
                } else {
                    if (entryKind == 1) {
                        result |= HAS_LIBRARY_CHANGE;
                    }
                    this.addBuildpathDeltas(delta, this.project.computeProjectFragments(newResolvedBuildpath[i]), 64);
                }
            }
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public void requestIndexing() {
        int index;
        IBuildpathEntry[] newResolvedBuildpath = null;
        try {
            newResolvedBuildpath = this.project.getResolvedBuildpath();
        }
        catch (ModelException modelException) {
            return;
        }
        ModelManager manager = ModelManager.getModelManager();
        IndexManager indexManager = manager.indexManager;
        if (indexManager == null) {
            return;
        }
        DeltaProcessingState state = manager.deltaState;
        int newLength = newResolvedBuildpath.length;
        int oldLength = this.oldResolvedBuildpath == null ? 0 : this.oldResolvedBuildpath.length;
        int i = 0;
        while (i < oldLength) {
            index = this.buildpathContains(newResolvedBuildpath, this.oldResolvedBuildpath[i]);
            if (index == -1 && this.oldResolvedBuildpath[i].getEntryKind() != 2) {
                IBuildpathEntry oldEntry = this.oldResolvedBuildpath[i];
                IPath path = oldEntry.getPath();
                int changeKind = this.oldResolvedBuildpath[i].getEntryKind();
                switch (changeKind) {
                    case 3: {
                        char[][] inclusionPatterns = ((BuildpathEntry)oldEntry).fullInclusionPatternChars();
                        char[][] exclusionPatterns = ((BuildpathEntry)oldEntry).fullExclusionPatternChars();
                        indexManager.removeSourceFolderFromIndex(this.project, path, inclusionPatterns, exclusionPatterns);
                        ProjectIndexerManager.removeProjectFragment(this.project, path);
                        break;
                    }
                    case 1: {
                        if (state.otherRoots.get(path) != null) break;
                        indexManager.discardJobs(path.toString());
                        indexManager.removeIndex(path);
                        ProjectIndexerManager.removeLibrary(this.project, path);
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            index = this.buildpathContains(this.oldResolvedBuildpath, newResolvedBuildpath[i]);
            if ((index == -1 || newResolvedBuildpath[i].getEntryKind() == 1) && newResolvedBuildpath[i].getEntryKind() != 2) {
                int entryKind = newResolvedBuildpath[i].getEntryKind();
                switch (entryKind) {
                    case 1: {
                        boolean pathHasChanged = true;
                        IPath newPath = newResolvedBuildpath[i].getPath();
                        int j = 0;
                        while (j < oldLength) {
                            IBuildpathEntry oldEntry = this.oldResolvedBuildpath[j];
                            if (oldEntry.getPath().equals((Object)newPath)) {
                                pathHasChanged = false;
                                break;
                            }
                            ++j;
                        }
                        if (!pathHasChanged) break;
                        ProjectIndexerManager.indexLibrary(this.project, newPath);
                        break;
                    }
                    case 3: {
                        IBuildpathEntry entry = newResolvedBuildpath[i];
                        IPath path = entry.getPath();
                        ProjectIndexerManager.indexProjectFragment(this.project, path);
                    }
                }
            }
            ++i;
        }
    }

    public String toString() {
        return "BuildpathChange: " + this.project.getElementName();
    }
}

