/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.templates.IScriptTemplateContext;
import org.eclipse.dltk.ui.templates.TemplateMessages;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public final class ScriptTemplateVariables {
    private ScriptTemplateVariables() {
    }

    private static ISourceModule getSourceModule(TemplateContext context) {
        return ((IScriptTemplateContext)context).getSourceModule();
    }

    public static class File
    extends TemplateVariableResolver {
        public static final String NAME = "file";

        public File() {
            super(NAME, TemplateMessages.Variable_File_Description);
        }

        protected String resolve(TemplateContext context) {
            ISourceModule module = ScriptTemplateVariables.getSourceModule(context);
            return module == null ? null : module.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class Interpreter
    extends TemplateVariableResolver {
        public static final String NAME = "interpreter";

        public Interpreter() {
            super(NAME, TemplateMessages.Variable_Interpreter_Description);
        }

        protected String resolve(TemplateContext context) {
            block4: {
                ISourceModule module = ScriptTemplateVariables.getSourceModule(context);
                if (module != null) {
                    try {
                        IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)module.getScriptProject());
                        if (install != null) {
                            return install.getRawInstallLocation().toOSString();
                        }
                    }
                    catch (CoreException e) {
                        if (!DLTKCore.DEBUG) break block4;
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class Language
    extends TemplateVariableResolver {
        public static final String NAME = "language";

        public Language() {
            super(NAME, TemplateMessages.Variable_Language_Description);
        }

        protected String resolve(TemplateContext context) {
            String name = null;
            ISourceModule module = ScriptTemplateVariables.getSourceModule(context);
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)module);
            name = toolkit.getLanguageName();
            return name;
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }
}

