/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tcf.internal.cdt.ui.ImageCache;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFBreakpointScopeExtension;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenContextQuery;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IWorkbenchPartSite;

public class TCFBreakpointScopeDetailPane
implements IDetailPane {
    public static final String ID = "org.eclipse.tcf.debug.DetailPaneFactory";
    public static final String NAME = "TCF Detail Pane";
    public static final String DESC = "TCF Detail Pane";
    private Composite fComposite;
    private Label fFilterName;
    private TreeModelViewer fTreeViewer;

    public Control createControl(Composite parent) {
        this.fComposite = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        this.fFilterName = SWTFactory.createLabel((Composite)this.fComposite, (String)"Scope", (int)1);
        this.fTreeViewer = new TreeModelViewer(this.fComposite, 0x10000000, (IPresentationContext)new PresentationContext("org.eclipse.tcf.debug.ui.ContextQueryView"));
        Control control = this.fTreeViewer.getControl();
        GridData treeLayoutData = new GridData(1808);
        treeLayoutData.horizontalIndent = 10;
        control.setLayoutData((Object)treeLayoutData);
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        return this.fComposite;
    }

    public void display(IStructuredSelection selection) {
        if (this.fTreeViewer == null) {
            return;
        }
        TCFBreakpointScopeExtension extension = this.getTCFBreakpointScopeExtension((ICBreakpoint)selection.getFirstElement());
        if (extension != null) {
            String filter = extension.getPropertiesFilter();
            if (filter != null && filter.trim().isEmpty()) {
                filter = null;
            }
            String[] contexts = extension.getThreadFilters();
            if (filter != null || contexts != null) {
                this.fFilterName.setText("Scope");
                TreeSet<String> contextsSet = contexts != null ? new TreeSet<String>(Arrays.asList(contexts)) : null;
                this.fTreeViewer.setInput((Object)new ScopeDetailInputObject(new ContextQueryElement(filter, contextsSet)));
                this.fTreeViewer.getPresentationContext().setProperty("query", (Object)filter);
                this.fTreeViewer.getPresentationContext().setProperty("contexts", contextsSet);
                this.fTreeViewer.refresh();
                return;
            }
        }
        this.fFilterName.setText("No scope specified.");
        this.fTreeViewer.setInput(null);
        this.fTreeViewer.getPresentationContext().setProperty("query", null);
        this.fTreeViewer.getPresentationContext().setProperty("contexts", null);
    }

    private TCFBreakpointScopeExtension getTCFBreakpointScopeExtension(ICBreakpoint bp) {
        if (bp == null) {
            return null;
        }
        try {
            return (TCFBreakpointScopeExtension)bp.getExtension("org.eclipse.tcf.debug", TCFBreakpointScopeExtension.class);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void dispose() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getControl().dispose();
            this.fTreeViewer = null;
        }
        if (this.fFilterName != null) {
            this.fFilterName.dispose();
            this.fFilterName = null;
        }
        if (this.fComposite != null) {
            this.fComposite.dispose();
            this.fComposite = null;
        }
    }

    public String getDescription() {
        return "TCF Detail Pane";
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return "TCF Detail Pane";
    }

    public void init(IWorkbenchPartSite part_site) {
    }

    public boolean setFocus() {
        if (this.fTreeViewer == null) {
            return false;
        }
        this.fTreeViewer.getControl().setFocus();
        return true;
    }

    public static class ContextQueryElement
    extends PlatformObject
    implements IElementContentProvider,
    IElementLabelProvider,
    IModelProxyFactory {
        private final String fQuery;
        private final Set<String> fScope;

        public ContextQueryElement(String query, Set<String> contexts) {
            this.fQuery = query;
            this.fScope = contexts;
        }

        public boolean equals(Object other) {
            if (other instanceof ContextQueryElement) {
                ContextQueryElement element = (ContextQueryElement)((Object)other);
                return (this.fQuery == null && element.fQuery == null || this.fQuery != null && this.fQuery.equals(element.fQuery)) && (this.fScope == null && element.fScope == null || this.fScope != null && this.fScope.equals(element.fScope));
            }
            return false;
        }

        public int hashCode() {
            return (this.fQuery != null ? this.fQuery.hashCode() : 0) + (this.fScope != null ? this.fScope.hashCode() : 0);
        }

        public void update(IChildrenCountUpdate[] updates) {
            IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                this.getFilteredLaunches((IViewerUpdate)update);
                ++n2;
            }
        }

        public void update(IChildrenUpdate[] updates) {
            IChildrenUpdate[] iChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenUpdate update = iChildrenUpdateArray[n2];
                this.getFilteredLaunches((IViewerUpdate)update);
                ++n2;
            }
        }

        public void update(IHasChildrenUpdate[] updates) {
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                this.getFilteredLaunches((IViewerUpdate)update);
                ++n2;
            }
        }

        public void update(ILabelUpdate[] updates) {
            ILabelUpdate[] iLabelUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                ILabelUpdate update = iLabelUpdateArray[n2];
                this.getQueryFilteredContexts(update);
                ++n2;
            }
        }

        private List<TCFLaunch> getTCFLaunches() {
            ArrayList<TCFLaunch> tcfLaunches = new ArrayList<TCFLaunch>();
            ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch instanceof TCFLaunch) {
                    tcfLaunches.add((TCFLaunch)launch);
                }
                ++n2;
            }
            return tcfLaunches;
        }

        private void getFilteredLaunches(final IViewerUpdate update) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ArrayList<TCFLaunch> filteredLaunches = new ArrayList<TCFLaunch>();
                    TCFModelManager modelManager = TCFModelManager.getModelManager();
                    for (TCFLaunch launch : ContextQueryElement.this.getTCFLaunches()) {
                        TCFModel model = modelManager.getModel(launch);
                        if (model == null || model.getRootNode() == null) continue;
                        TCFChildrenContextQuery.Descendants des = TCFChildrenContextQuery.getDescendants((TCFNode)model.getRootNode(), (String)ContextQueryElement.this.fQuery, (Set)ContextQueryElement.this.fScope, (Runnable)this);
                        if (des == null) {
                            return;
                        }
                        if (des.map == null || des.map.size() <= 0) continue;
                        filteredLaunches.add(launch);
                    }
                    ContextQueryElement.this.done(filteredLaunches, update);
                }
            });
        }

        private void getQueryFilteredContexts(final ILabelUpdate update) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    HashMap<String, String> node_names = new HashMap<String, String>();
                    TCFModelManager model_manager = TCFModelManager.getModelManager();
                    HashSet descendants = new HashSet();
                    for (TCFModel model : model_manager.getModels()) {
                        if (!model.getLaunch().isConnected()) continue;
                        TCFChildrenContextQuery.Descendants des = TCFChildrenContextQuery.getDescendants((TCFNode)model.getRootNode(), (String)ContextQueryElement.this.fQuery, (Set)ContextQueryElement.this.fScope, (Runnable)this);
                        if (des == null) {
                            return;
                        }
                        if (des.map != null) {
                            descendants.addAll(des.map.keySet());
                        }
                        if (ContextQueryElement.this.fScope == null) continue;
                        String launch_name = model.getLaunch().getLaunchConfiguration().getName();
                        for (String id : ContextQueryElement.this.fScope) {
                            String name;
                            TCFNode node;
                            int i;
                            if (node_names.containsKey(id) || (i = id.indexOf(47)) < 0 || !launch_name.equals(id.substring(0, i)) || !((node = model.getNode(id.substring(i + 1))) instanceof TCFNodeExecContext)) continue;
                            TCFDataCache ctx_cache = ((TCFNodeExecContext)node).getRunContext();
                            if (!ctx_cache.validate((Runnable)this)) {
                                return;
                            }
                            IRunControl.RunControlContext ctx_data = (IRunControl.RunControlContext)ctx_cache.getData();
                            if (ctx_data == null || (name = ctx_data.getName()) == null) continue;
                            node_names.put(id, name);
                        }
                    }
                    StringBuffer label = new StringBuffer();
                    label.append("(");
                    label.append(descendants.size());
                    label.append(") ");
                    if (ContextQueryElement.this.fQuery != null) {
                        label.append("Filter: ");
                        label.append(ContextQueryElement.this.fQuery);
                        if (ContextQueryElement.this.fScope != null) {
                            label.append(", ");
                        }
                    }
                    if (ContextQueryElement.this.fScope != null) {
                        int cnt = 0;
                        label.append("Contexts: ");
                        label.append('[');
                        for (String id : ContextQueryElement.this.fScope) {
                            String name;
                            if (cnt > 0) {
                                label.append(',');
                            }
                            label.append((name = (String)node_names.get(id)) != null ? name : id);
                            ++cnt;
                        }
                        label.append(']');
                    }
                    update.setLabel(label.toString(), 0);
                    update.setImageDescriptor(ImageCache.getImageDescriptor("icons/obj16/bp_scope.gif"), 0);
                    update.done();
                }
            });
        }

        private void done(List<TCFLaunch> launches, IViewerUpdate update) {
            if (update instanceof IHasChildrenUpdate) {
                ((IHasChildrenUpdate)update).setHasChilren(!launches.isEmpty());
            } else if (update instanceof IChildrenCountUpdate) {
                ((IChildrenCountUpdate)update).setChildCount(launches.size());
            } else if (update instanceof IChildrenUpdate) {
                IChildrenUpdate childrenUpdate = (IChildrenUpdate)update;
                int updateStart = childrenUpdate.getOffset();
                int updateEnd = childrenUpdate.getOffset() + childrenUpdate.getLength();
                int i = updateStart;
                while (i < updateEnd && i < launches.size()) {
                    childrenUpdate.setChild((Object)launches.get(i), i);
                    ++i;
                }
            }
            update.done();
        }

        public IModelProxy createModelProxy(Object element, IPresentationContext context) {
            return new QueryInputObjectProxy();
        }
    }

    public static class QueryInputObjectProxy
    extends AbstractModelProxy
    implements ILaunchesListener2 {
        private ILaunchManager fLaunchManager;

        public synchronized void init(IPresentationContext context) {
            super.init(context);
            this.fLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            this.fLaunchManager.addLaunchListener((ILaunchesListener)this);
        }

        public void installed(Viewer viewer) {
            ILaunch[] launches = this.fLaunchManager.getLaunches();
            if (launches.length > 0) {
                this.launchesAdded(launches);
            }
        }

        public synchronized void dispose() {
            super.dispose();
            if (this.fLaunchManager != null) {
                this.fLaunchManager.removeLaunchListener((ILaunchesListener)this);
                this.fLaunchManager = null;
            }
        }

        public void launchesTerminated(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
            this.fireDelta(launches, 2);
        }

        public void launchesAdded(ILaunch[] launches) {
            this.fireDelta(launches, 0x400001);
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        protected void fireDelta(ILaunch[] launches, int launchFlags) {
            ModelDelta delta = new ModelDelta((Object)this.fLaunchManager, 0);
            int i = 0;
            while (i < launches.length) {
                if (launches[i] instanceof TCFLaunch) {
                    delta.addNode((Object)launches[i], launchFlags);
                }
                ++i;
            }
            this.fireModelChanged((IModelDelta)delta);
        }
    }

    public static class ScopeDetailInputObject
    extends PlatformObject
    implements IElementContentProvider,
    IModelProxyFactory {
        private final ContextQueryElement fContextQueryElement;

        public ScopeDetailInputObject(ContextQueryElement query) {
            this.fContextQueryElement = query;
        }

        public boolean equals(Object other) {
            if (other instanceof ScopeDetailInputObject) {
                return this.fContextQueryElement.equals((Object)((ScopeDetailInputObject)((Object)other)).fContextQueryElement);
            }
            return false;
        }

        public int hashCode() {
            return this.fContextQueryElement.hashCode();
        }

        public void update(IChildrenCountUpdate[] updates) {
            IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                update.setChildCount(1);
                update.done();
                ++n2;
            }
        }

        public void update(IChildrenUpdate[] updates) {
            IChildrenUpdate[] iChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenUpdate update = iChildrenUpdateArray[n2];
                if (update.getOffset() == 0) {
                    update.setChild((Object)this.fContextQueryElement, 0);
                    update.done();
                }
                ++n2;
            }
        }

        public void update(IHasChildrenUpdate[] updates) {
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                update.setHasChilren(true);
                update.done();
                ++n2;
            }
        }

        public IModelProxy createModelProxy(Object element, IPresentationContext context) {
            return new AbstractModelProxy(){

                public void initialize(ITreeModelViewer viewer) {
                    super.initialize(viewer);
                    ModelDelta delta = new ModelDelta((Object)this, 0);
                    delta.addNode((Object)ScopeDetailInputObject.this.fContextQueryElement, 0, 0x400000);
                    this.fireModelChanged((IModelDelta)delta);
                }
            };
        }
    }
}

