/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.pkgmanager.RView;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class RViewTasks {
    RViewTasks() {
    }

    static List<RView> loadRViews(RService r, ProgressMonitor m) {
        String dir;
        Throwable error;
        block5: {
            error = null;
            m.beginSubTask("Loading R task views...");
            FunctionCall call = r.createFunctionCall("system.file");
            call.addChar("ctv");
            call.addChar("package", "ctv");
            dir = RDataUtils.checkSingleChar((RObject)call.evalData(m));
            if (dir != null && !dir.equals("")) break block5;
            return null;
        }
        try {
            FunctionCall call = r.createFunctionCall("dir");
            call.addChar("path", dir);
            RCharacterStore data = (RCharacterStore)RDataUtils.checkRCharVector((RObject)call.evalData(m)).getData();
            String[] files = data.toArray();
            ArrayList<RView> views = new ArrayList<RView>(files.length);
            String sep = r.getPlatform().getFileSep();
            CRANViewHandler handler = new CRANViewHandler(views);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            XMLReader reader = saxParserFactory.newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            int i = 0;
            while (i < files.length) {
                byte[] file;
                if (files[i].endsWith(".ctv") && (file = r.downloadFile(String.valueOf(dir) + sep + files[i], 0, m)).length > 0) {
                    reader.parse(new InputSource(new ByteArrayInputStream(file)));
                }
                ++i;
            }
            return views;
        }
        catch (IOException | ParserConfigurationException | StatusException | UnexpectedRDataException | SAXException e) {
            RCorePlugin.logError("An error occurred when loading R task views.", error);
            return null;
        }
    }

    private static class CRANViewHandler
    extends DefaultHandler {
        private static final int S_VIEW = 1;
        private static final int S_NAME = 2;
        private static final int S_TOPIC = 3;
        private static final int S_PKGLIST = 4;
        private static final int S_PKGLIST_PKG = 5;
        private final List<RView> viewList;
        private RView view;
        private final StringBuilder string = new StringBuilder();
        private int state = -1;
        private int depth;
        private int skipDepth;

        public CRANViewHandler(List<RView> viewList) {
            this.viewList = viewList;
        }

        @Override
        public void startDocument() throws SAXException {
            this.state = 0;
            this.depth = 0;
            this.skipDepth = Integer.MAX_VALUE;
        }

        @Override
        public void endDocument() throws SAXException {
            this.state = -1;
        }

        private void enter(int newState) {
            this.state = newState;
        }

        private void exit(int newState) {
            this.state = newState;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.depth;
            if (this.depth < this.skipDepth) {
                switch (this.state) {
                    case 0: {
                        if (!localName.equals("CRANTaskView")) break;
                        this.enter(1);
                        this.view = null;
                        return;
                    }
                    case 1: {
                        if (localName.equals("name")) {
                            if (this.view != null) break;
                            this.enter(2);
                            this.string.setLength(0);
                            return;
                        }
                        if (localName.equals("topic")) {
                            if (this.view == null) break;
                            this.enter(3);
                            this.string.setLength(0);
                            return;
                        }
                        if (!localName.equals("packagelist") || this.view == null) break;
                        this.enter(4);
                        return;
                    }
                    case 4: {
                        if (!localName.equals("pkg")) break;
                        this.enter(5);
                        this.string.setLength(0);
                        return;
                    }
                }
                this.skipDepth = this.depth;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.depth < this.skipDepth) {
                switch (this.state) {
                    case 1: {
                        if (this.view != null && !this.view.getPkgList().isEmpty()) {
                            this.viewList.add(this.view);
                            this.view = null;
                        }
                        this.exit(0);
                        break;
                    }
                    case 4: {
                        this.exit(1);
                        break;
                    }
                    case 2: {
                        if (this.string.length() > 0) {
                            this.view = new RView(this.string.toString());
                        }
                        this.exit(1);
                        break;
                    }
                    case 3: {
                        if (this.string.length() > 0) {
                            this.view.setTopic(this.string.toString());
                        }
                        this.exit(1);
                        break;
                    }
                    case 5: {
                        if (this.string.length() > 0) {
                            this.view.getPkgList().add(this.string.toString().intern());
                        }
                        this.exit(4);
                    }
                }
            } else if (this.depth == this.skipDepth) {
                this.skipDepth = Integer.MAX_VALUE;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case 2: 
                case 3: 
                case 5: {
                    this.string.append(ch, start, length);
                }
            }
        }
    }
}

