/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.action;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.edit.EditCellCommand;
import org.eclipse.statet.ecommons.waltable.selection.ui.action.CellSelectionDragMode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;

public class CellEditDragMode
extends CellSelectionDragMode {
    private long originalColumnPosition;
    private long originalRowPosition;

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        super.mouseDown(natTable, event);
        long columnPosition = natTable.getColumnPositionByX(event.x);
        long rowPosition = natTable.getRowPositionByY(event.y);
        this.originalColumnPosition = columnPosition;
        this.originalRowPosition = rowPosition;
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        super.mouseMove(natTable, event);
        long columnPosition = natTable.getColumnPositionByX(event.x);
        long rowPosition = natTable.getRowPositionByY(event.y);
        if (columnPosition != this.originalColumnPosition || rowPosition != this.originalRowPosition) {
            this.originalColumnPosition = -1L;
            this.originalRowPosition = -1L;
        }
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        super.mouseUp(natTable, event);
        long columnPosition = natTable.getColumnPositionByX(event.x);
        long rowPosition = natTable.getRowPositionByY(event.y);
        if (columnPosition < 0L || columnPosition != this.originalColumnPosition || rowPosition < 0L || rowPosition != this.originalRowPosition) {
            return;
        }
        natTable.doCommand(new EditCellCommand((Composite)natTable, natTable.getConfigRegistry(), natTable.getCellByPosition(columnPosition, rowPosition)));
    }
}

