/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.tokens;

import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SyntaxProblem;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class Token {
    private final int startIndex;
    private final int endIndex;
    private final @Nullable SyntaxProblem problem;

    public Token(int startIndex, int endIndex, @Nullable SyntaxProblem problem) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.problem = problem;
    }

    public abstract ID getTokenId();

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getLength() {
        return this.endIndex - this.startIndex;
    }

    public @Nullable SyntaxProblem getProblem() {
        return this.problem;
    }

    public String toString() {
        return this.getTokenId().toString();
    }

    public static enum ID {
        Alias("<alias>"),
        Anchor("<anchor>"),
        BlockEnd("<block end>"),
        BlockEntry("-"),
        BlockMappingStart("<block mapping start>"),
        BlockSequenceStart("<block sequence start>"),
        Directive("<directive>"),
        DocumentEnd("<document end>"),
        DocumentStart("<document start>"),
        FlowEntry(","),
        FlowMappingEnd("}"),
        FlowMappingStart("{"),
        FlowSequenceEnd("]"),
        FlowSequenceStart("["),
        Key("?"),
        Scalar("<scalar>"),
        StreamEnd("<stream end>"),
        StreamStart("<stream start>"),
        Tag("<tag>"),
        Comment("#"),
        Value(":"),
        ERROR("<ERROR>");

        private final String description;

        private ID(String s) {
            this.description = s;
        }

        public String toString() {
            return this.description;
        }
    }
}

